package gov.va.med.mhv.getcare.web.dao;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderResponse;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

@Component
public class HealthCareProviderDaoImpl implements HealthCareProviderDao, Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthCareProviderDaoImpl.class);

	@Value("${endpointUrl}")
	private String endpointUrl;

	private static final String HEALTHCARE_PROVIDER_WS = "healthcareprovider";

	@Override
	public List<HealthCareProviderDTO> findByProfileId(String userProfileId) {
		Reader responseReader = null;
		List<HealthCareProviderDTO> dtoList = null;

		logger.debug("creating gson");
		Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();

		logger.debug("creating client " + endpointUrl);
		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_PROVIDER_WS).path("get/{id}", userProfileId)
				.accept(MediaType.APPLICATION_JSON);

		logger.debug("reading stream");
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());

		logger.debug("converting");
		Type type = new TypeToken<List<HealthCareProviderDTO>>() {
		}.getType();
		dtoList = gson.fromJson(responseReader, type);

		if (dtoList != null && dtoList.size() > 0)
			logger.debug(Arrays.toString(dtoList.toArray()));
		else
			logger.debug("no results");

		return dtoList;
	}

	@Override
	public String ping(String message) {
		logger.debug("creating client " + endpointUrl);
		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_PROVIDER_WS).path("ping/{msg}", message)
				.accept(MediaType.TEXT_PLAIN);

		String result = client.get(String.class);

		logger.debug(result);

		return result;
	}

	@Override
	public HealthCareProviderResponse save(HealthCareProviderDTO dto) {
		logger.debug("Saving: " + dto);
		HealthCareProviderResponse result = null;

		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_PROVIDER_WS).path("save")
				.accept(MediaType.APPLICATION_JSON).type(MediaType.APPLICATION_JSON);

		logger.debug("Saving gson");
		Gson gson = new GsonBuilder().create();

		String dtoJSON = gson.toJson(dto);

		logger.debug("posting");
		Response r = client.post(dtoJSON);

		Reader responseReader = new InputStreamReader((InputStream) r.getEntity());

		logger.debug("saved");
		result = gson.fromJson(responseReader, HealthCareProviderResponse.class);
		logger.debug(result);

		return result;
	}

	@Override
	public HealthCareProviderResponse delete(HealthCareProviderDTO dto) {
		logger.debug("Deleting: " + dto);
		
		HealthCareProviderResponse result = new HealthCareProviderResponse();
		result.setHealthCareProviderDTO(dto);

		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_PROVIDER_WS).path("delete")
				.accept(MediaType.APPLICATION_JSON).type(MediaType.APPLICATION_JSON);

		logger.debug("Deleting gson");
		Gson gson = new GsonBuilder().create();

		String dtoJSON = gson.toJson(dto);

		logger.debug("posting");
		Response r = client.post(dtoJSON);

		Reader responseReader = new InputStreamReader((InputStream) r.getEntity());

		logger.debug("deleted");
		result = gson.fromJson(responseReader, HealthCareProviderResponse.class);
		logger.debug(result);

		return result;
	}

}
