package gov.va.med.mhv.getcare.web.converter;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.web.bean.TreatmentLocationModelBean;

@Component
public class TreatmentFacilityConverter implements IConverter<TreatmentFacilityDTO, TreatmentLocationModelBean> {

	@Override
	public TreatmentLocationModelBean convert(TreatmentFacilityDTO dto) {
		TreatmentLocationModelBean m = new TreatmentLocationModelBean();
		
		m.setAddressCity(dto.getAddressCity());
		m.setAddressCountry(dto.getAddressCountry());
		m.setAddressCountry(dto.getAddressCity());
		m.setAddressPostalCode(dto.getAddressPostalCode());
		m.setAddressProvince(dto.getAddressProvince());
		m.setAddressState(dto.getAddressState());		
		m.setAddressStreet1(dto.getAddressStreet1());
		m.setAddressStreet2(dto.getAddressStreet2());
		m.setComments(dto.getComments());
		m.setContactInfoFax(dto.getContactInfoFax());
		m.setContactInfoWorkPhone(dto.getContactInfoWorkPhone());
		m.setContactInfoWorkPhoneExt(dto.getContactInfoWorkPhoneExt());
		m.setFacilityName(dto.getFacilityName());
		m.setFacilityType(dto.getFacilityType());
		m.setHomeFacility(dto.getHomeFacility());
		m.setOplock(dto.getOplock());
		
		return m;
	}

	@Override
	public TreatmentFacilityDTO convertToDto(TreatmentLocationModelBean m) {
		TreatmentFacilityDTO dto = new TreatmentFacilityDTO();
		
		dto.setAddressCity(m.getAddressCity());
		dto.setAddressCountry(m.getAddressCountry());
		dto.setAddressCountry(m.getAddressCity());
		dto.setAddressPostalCode(m.getAddressPostalCode());
		dto.setAddressProvince(m.getAddressProvince());
		dto.setAddressState(m.getAddressState());		
		dto.setAddressStreet1(m.getAddressStreet1());
		dto.setAddressStreet2(m.getAddressStreet2());
		dto.setComments(m.getComments());
		dto.setContactInfoFax(m.getContactInfoFax());
		dto.setContactInfoWorkPhone(m.getContactInfoWorkPhone());
		dto.setContactInfoWorkPhoneExt(m.getContactInfoWorkPhoneExt());
		dto.setFacilityName(m.getFacilityName());
		dto.setFacilityType(m.getFacilityType());
		dto.setHomeFacility(m.getHomeFacility());
		dto.setOplock(m.getOplock());
		
		return dto;
	}

}
