package gov.va.med.mhv.getcare.web.converter;

import java.io.Serializable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.web.bean.HealthInsuranceModelBean;

@Component
public class HealthInsuranceConverter implements IConverter<HealthInsuranceDTO, HealthInsuranceModelBean>, Serializable {
	private static final long serialVersionUID = 1L;
	
	private static Logger logger = LogManager.getLogger(HealthInsuranceConverter.class);
	
	@Override
	public HealthInsuranceModelBean convert(HealthInsuranceDTO dto) {
		HealthInsuranceModelBean model = new HealthInsuranceModelBean();

		model.setUserProfileId(dto.getUserProfileId());
		model.setHealthInsuranceId(dto.getHealthInsuranceId());
		model.setCompanyName(dto.getCompanyName());
		model.setCompanyPhone(dto.getCompanyPhone());
		model.setGroupNumber(dto.getGroupNumber());
		model.setFirstNameOfInsured(dto.getFirstNameOfInsured());
		model.setLastNameOfInsured(dto.getLastNameOfInsured());
		model.setInsuranceIdNumber(dto.getInsuranceIdNumber());
		model.setPreApprovalPhone(dto.getPreApprovalPhone());
		model.setStartDate(dto.getStartDate());
		model.setStopDate(dto.getStopDate());
		model.setPrimaryInd(dto.getPrimaryInd() != 0);
		model.setComments(dto.getComments());
		model.setOplock(dto.getOplock());
		
		logger.debug(dto);
		logger.debug(model);
		
		return model;
	}

	@Override
	public HealthInsuranceDTO convertToDto(HealthInsuranceModelBean model) {
		HealthInsuranceDTO dto = new HealthInsuranceDTO();
		
		dto.setUserProfileId(model.getUserProfileId());
		dto.setHealthInsuranceId(model.getHealthInsuranceId());
		dto.setCompanyName(model.getCompanyName());
		dto.setCompanyPhone(model.getCompanyPhone());
		dto.setGroupNumber(model.getGroupNumber());
		dto.setFirstNameOfInsured(model.getFirstNameOfInsured());
		dto.setLastNameOfInsured(model.getLastNameOfInsured());
		dto.setInsuranceIdNumber(model.getInsuranceIdNumber());
		dto.setPreApprovalPhone(model.getPreApprovalPhone());
		dto.setStartDate(model.getStartDate());
		dto.setStopDate(model.getStopDate());
		dto.setPrimaryInd(model.getPrimaryInd() ? 1L : 0L);
		dto.setComments(model.getComments());
		dto.setOplock(model.getOplock());
		
		logger.debug(model);
		logger.debug(dto);

		return dto;
	}

}
