package gov.va.med.mhv.getcare.web.converter;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.web.bean.CareGiverModelBean;

import java.io.Serializable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CareGiverConverter implements IConverter<HealthCareProviderDTO, CareGiverModelBean>, Serializable {

	private static final long serialVersionUID = 1L;
	
	private static Logger logger = LogManager.getLogger(CareGiverConverter.class);

	public CareGiverModelBean convert(HealthCareProviderDTO dto) {
		CareGiverModelBean cg = new CareGiverModelBean();

		cg.setUserProfileId(dto.getUserProfileId());
		cg.setCareGiverId(dto.getHealthCareProviderId());
		cg.setEmailAddress(dto.getEmailAddress());
		cg.setFirstName(dto.getFirstName());
		cg.setLastName(dto.getLastName());
		cg.setOtherClinician(dto.getOtherClinician());
		cg.setWorkPhone(dto.getWorkPhone());
		cg.setWorkPhoneExt(dto.getWorkPhoneExt());
		cg.setComments(dto.getComments());
		
		if (dto.getProviderType().equals("P")) {
			cg.setProviderType("Primary");
		} else if (dto.getProviderType().equals("S")) {
			cg.setProviderType("Specialist");
		} else if (dto.getProviderType().equals("D")) {
			cg.setProviderType("Dentist");
		} else if (dto.getProviderType().equals("E")) {
			cg.setProviderType("Eye");
		} else if (dto.getProviderType().equals("O")) {
			cg.setProviderType("Other Clinician");
		}	
		
		logger.debug(dto);
		logger.debug(cg);
		
		return cg;
	}

	public HealthCareProviderDTO convertToDto(CareGiverModelBean cg) {
		HealthCareProviderDTO dto = new HealthCareProviderDTO();

		dto.setUserProfileId(cg.getUserProfileId());
		dto.setHealthCareProviderId(cg.getCareGiverId());
		dto.setEmailAddress(cg.getEmailAddress());
		dto.setFirstName(cg.getFirstName());
		dto.setHealthCareProviderId(cg.getCareGiverId());
		dto.setLastName(cg.getLastName());
		dto.setOtherClinician(cg.getOtherClinician());
		dto.setWorkPhone(cg.getWorkPhone());
		dto.setWorkPhoneExt(cg.getWorkPhoneExt());
		dto.setComments(cg.getComments());
		dto.setOplock(0);
		
		if (cg.getProviderType().equals("Primary")) {
			dto.setProviderType("P");
		} else if (cg.getProviderType().equals("Specialist")) {
			dto.setProviderType("S");
		} else if (cg.getProviderType().equals("Dentist")) {
			dto.setProviderType("D");
		} else if (cg.getProviderType().equals("Eye")) {
			dto.setProviderType("E");
		} else if (cg.getProviderType().equals("Other Clinician")) {
			dto.setProviderType("O");
		}	

		logger.debug(cg);
		logger.debug(dto);
		
		return dto;
	}

}
