package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.web.converter.TreatmentFacilityConverter;
import gov.va.med.mhv.getcare.web.dao.TreatmentFacilityDao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("request")
public class TreatmentLocationsDashboardViewBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(TreatmentLocationsDashboardViewBean.class);

	@Autowired
	private TreatmentFacilityDao dao;

	@Autowired
	private TreatmentFacilityConverter converter;

	private List<TreatmentLocationModelBean> viewList = new ArrayList<TreatmentLocationModelBean>();

	public List<TreatmentLocationModelBean> getViewList() {
		return viewList;
	}

	public void updateModel() {
		List<TreatmentFacilityDTO> dtoList = null;

		viewList.clear();
		
		dtoList = dao.findByProfileId("9712240");

		for (TreatmentFacilityDTO dto : dtoList) {
			logger.debug(dto);
			TreatmentLocationModelBean m = converter.convert(dto);
			viewList.add(m);
		}
	}
	
	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
		updateModel();
	}
}
