package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.web.common.ViewMode;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean
@Component
@Scope("request")
public class TreatmentLocationsController implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(TreatmentLocationsController.class);

	@Autowired
	private TreatmentLocationsViewBean view;

	@Autowired
	private TreatmentLocationModelBean model;
	
//	@Autowired
//	private TreatmentLocationsDao dao;
//	
//	@Autowired
//	private TreatmentLocationsConverter converter;

	public String getFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getFirstName() : "???");
	}

	public String getLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getLastName() : "???");
	}

	public void view(String id) {
		logger.debug("view:" + id);
		HealthInsuranceModelBean bean = findCareGiver(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_VIEW);
		}
	}

	public void viewPF() {
		logger.debug("viewPF");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_VIEW_PF);
	}

	public void edit(String id) {
		logger.debug("edit:" + id);
		HealthInsuranceModelBean bean = findCareGiver(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_EDIT);
		}
	}

	public void edit() {
		logger.debug("edit");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_EDIT);
	}

	public void delete(String id) {
		HealthInsuranceModelBean bean = findCareGiver(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_DELETE);
		}
	}
	
	public void delete() {
//		HealthCareProviderDTO dto = converter.convertToDto(HealthInsuranceModelBean);
//		
//		HealthCareProviderResponse r = dao.deleteHealthCareProvider(dto);

		view.setViewMode(ViewMode.VM_SUMMARY);

		view.updateModel();
	}


	public void save() {
		logger.debug("save");
		logger.debug(model);
		
//		HealthCareProviderDTO dto = converter.convertToDto(healthInsuranceModelBean);
//		
//		HealthCareProviderResponse r = dao.saveHealthCareProvider(dto);
//				
//		healthInsuranceModelBean.setCareGiverId(r.getHealthCareProviderDTO().getHealthCareProviderId());
		
		logger.debug(model);
		
		view.updateModel();
	}

	public void saveAndAddNew() {
		logger.debug("saveAndAddNew");
		//TODO: check validation
		save();
		model.clearProperties();
		model.setTreatmentFacilityId(null);
	}

	public void addNew() {
		logger.debug("add new");
		model.clearProperties();
		model.setUserProfileId(9712240L);
		view.setViewMode(ViewMode.VM_ADD);
	}

	public void cancel() {
		logger.debug("cancel");
		logger.debug(view);
		view.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void reset() {
		logger.debug("reset");
		model.clearProperties();
	}

	public void showPrinterFriendly() {
		logger.debug("showPrinterFriendly");
		logger.debug(view);
		view.setViewMode(ViewMode.VM_SUMMARY_PF);
	}

	private HealthInsuranceModelBean findCareGiver(String id) {
		HealthInsuranceModelBean bean = null;
		Long cgId = null;
		
//		try {
//			cgId = Long.valueOf(id);
//			for (TreatmentLocationModelBean cg : viewBean.getViewList()) {
//				logger.debug(cg);
//				if (cg.getHealthInsuranceId().equals(cgId)) {
//					bean = cg;
//					modelBean.setProperties(cg);
//					break;
//				}
//			}
//			logger.debug(bean == null ? id + " not found" : id + " found");
//			
//		} catch(Exception e) {
//			logger.warn("invalid id: " + id);
//		}
		return bean;
	}

}
