package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.web.common.StringUtils;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class TreatmentLocationModelBean implements Serializable {
	private static final long serialVersionUID = 1L;
	
	private Long userProfileId;
	private Long treatmentFacilityId;
	private String addressCity;
	private String addressCountry;
	private String addressPostalCode;
	private String addressProvince;
	private String addressState;
	private String addressStreet1;
	private String addressStreet2;
	private String comments;
	private String contactInfoFax;
	private String contactInfoWorkPhone;
	private String contactInfoWorkPhoneExt;
	private String facilityName;
	private String facilityType;
	private Long homeFacility;
	private Integer oplock;

	public Long getUserProfileId() {
		return userProfileId;
	}
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	public Long getTreatmentFacilityId() {
		return treatmentFacilityId;
	}
	public void setTreatmentFacilityId(Long treatmentFacilityId) {
		this.treatmentFacilityId = treatmentFacilityId;
	}
	public String getAddressCity() {
		return addressCity;
	}
	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}
	public String getAddressCountry() {
		return addressCountry;
	}
	public void setAddressCountry(String addressCountry) {
		this.addressCountry = addressCountry;
	}
	public String getAddressPostalCode() {
		return addressPostalCode;
	}
	public void setAddressPostalCode(String addressPostalCode) {
		this.addressPostalCode = addressPostalCode;
	}
	public String getAddressProvince() {
		return addressProvince;
	}
	public void setAddressProvince(String addressProvince) {
		this.addressProvince = addressProvince;
	}
	public String getAddressState() {
		return addressState;
	}
	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}
	public String getAddressStreet1() {
		return addressStreet1;
	}
	public void setAddressStreet1(String addressStreet1) {
		this.addressStreet1 = addressStreet1;
	}
	public String getAddressStreet2() {
		return addressStreet2;
	}
	public void setAddressStreet2(String addressStreet2) {
		this.addressStreet2 = addressStreet2;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getContactInfoFax() {
		return contactInfoFax;
	}
	public void setContactInfoFax(String contactInfoFax) {
		this.contactInfoFax = contactInfoFax;
	}
	public String getContactInfoWorkPhone() {
		return contactInfoWorkPhone;
	}
	public void setContactInfoWorkPhone(String contactInfoWorkPhone) {
		this.contactInfoWorkPhone = contactInfoWorkPhone;
	}
	public String getContactInfoWorkPhoneExt() {
		return contactInfoWorkPhoneExt;
	}
	public void setContactInfoWorkPhoneExt(String contactInfoWorkPhoneExt) {
		this.contactInfoWorkPhoneExt = contactInfoWorkPhoneExt;
	}
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	public String getFacilityType() {
		return facilityType;
	}
	public void setFacilityType(String facilityType) {
		this.facilityType = facilityType;
	}
	public Long getHomeFacility() {
		return homeFacility;
	}
	public void setHomeFacility(Long homeFacility) {
		this.homeFacility = homeFacility;
	}
	public Integer getOplock() {
		return oplock;
	}
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}
	
	public String getFullPhoneNumber() {
		return StringUtils.fullPhoneNumber(this.contactInfoWorkPhone, this.contactInfoWorkPhoneExt);
	}
	public void setProperties(TreatmentLocationModelBean model) {
		
	}
	public void clearProperties() {
		
	}

}