package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceResponse;
import gov.va.med.mhv.getcare.web.common.ViewMode;
import gov.va.med.mhv.getcare.web.converter.HealthInsuranceConverter;
import gov.va.med.mhv.getcare.web.dao.HealthInsuranceDao;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean
@Component
@Scope("request")
public class HealthInsuranceController implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthInsuranceController.class);

	@Autowired
	private HealthInsuranceViewBean view;

	@Autowired
	private HealthInsuranceModelBean model;

	@Autowired
	private HealthInsuranceDao dao;

	@Autowired
	private HealthInsuranceConverter converter;

	public String getFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getFirstName() : "???");
	}

	public String getLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getLastName() : "???");
	}

	public void view(Long id) {
		logger.debug("view:" + id);
		HealthInsuranceModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_VIEW);
		}
	}

	public void viewPF() {
		logger.debug("viewPF");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_VIEW_PF);
	}

	public void edit(Long id) {
		logger.debug("edit:" + id);
		HealthInsuranceModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_EDIT);
		}
	}

	public void edit() {
		logger.debug("edit");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_EDIT);
	}

	public void delete(Long id) {
		HealthInsuranceModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_DELETE);
		}
	}

	public void delete() {
		HealthInsuranceDTO dto = converter.convertToDto(model);

		HealthInsuranceResponse r = dao.delete(dto);

		view.setViewMode(ViewMode.VM_SUMMARY);

		view.updateModel();
	}

	public void save() {
		logger.debug("save");

		HealthInsuranceDTO dto = converter.convertToDto(model);

		HealthInsuranceResponse r = dao.save(dto);

		model.setHealthInsuranceId(r.getDTO().getHealthInsuranceId());

		view.setViewMode(ViewMode.VM_SUMMARY);
		
		view.updateModel();
	}

	public void saveAndAddNew() {
		logger.debug("saveAndAddNew");
		// TODO: check validation
		save();
		model.clearProperties();
		model.setHealthInsuranceId(null);
	}

	public void addNew() {
		logger.debug("add new");
		model.clearProperties();
		model.setUserProfileId(9712240L);
		view.setViewMode(ViewMode.VM_ADD);
	}

	public void cancel() {
		logger.debug("cancel");
		logger.debug(view);
		view.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void reset() {
		logger.debug("reset");
		view.updateModel();
		HealthInsuranceModelBean b = find(model.getHealthInsuranceId());
		// reset to database or clear properties
		model.setProperties(b);
	}

	public void showPrinterFriendly() {
		logger.debug("showPrinterFriendly");
		logger.debug(view);
		view.setViewMode(ViewMode.VM_SUMMARY_PF);
	}

	private HealthInsuranceModelBean find(Long id) {
		HealthInsuranceModelBean bean = null;

		for (HealthInsuranceModelBean m : view.getViewList()) {
			logger.debug(m);
			if (m.getHealthInsuranceId().equals(id)) {
				bean = m;
				model.setProperties(m);
				break;
			}
		}
		
		logger.debug(bean == null ? id + " not found" : id + " found");

		return bean;
	}

}
