package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.web.common.ViewMode;
import gov.va.med.mhv.getcare.web.converter.CareGiverConverter;
import gov.va.med.mhv.getcare.web.dao.HealthCareProviderDao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class HealthCareProviderViewBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private static Logger logger = LogManager.getLogger(HealthCareProviderViewBean.class);
	
	@Autowired
	private HealthCareProviderDao dao;

	@Autowired
	private CareGiverConverter converter;

	private List<CareGiverModelBean> viewList = new ArrayList<CareGiverModelBean>();
	
	private String viewMode = ViewMode.VM_SUMMARY;

	public List<CareGiverModelBean> getViewList() {
		return viewList;
	}

	public void updateModel() {
		List<HealthCareProviderDTO> dtoList = null;

		viewList.clear();
		
		dtoList = dao.findByProfileId("9712240");

		for (HealthCareProviderDTO dto : dtoList) {
			CareGiverModelBean cg = converter.convert(dto);
			viewList.add(cg);
		}
		
		logger.debug(this);
	}
	
	public String getViewMode() {
		return viewMode;
	}

	public void setViewMode(String viewMode) {
		logger.debug("viewMode=" + viewMode);
		this.viewMode = viewMode;
	}

	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
		updateModel();
	}

	@Override
	public String toString() {
		return "HealthCareProviderViewBean [dao=" + dao + ", converter=" + converter + ", viewList=" + viewList
				+ ", viewMode=" + viewMode + "]";
	}
		
}
