package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderResponse;
import gov.va.med.mhv.getcare.web.common.ViewMode;
import gov.va.med.mhv.getcare.web.converter.CareGiverConverter;
import gov.va.med.mhv.getcare.web.dao.HealthCareProviderDao;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean
@Component
@Scope("request")
public class HealthCareProviderController implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthCareProviderController.class);

	@Autowired
	private HealthCareProviderViewBean view;

	@Autowired
	private CareGiverModelBean model;

	@Autowired
	private HealthCareProviderDao dao;

	@Autowired
	private CareGiverConverter converter;

	public String getFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getFirstName() : "???");
	}

	public String getLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			logger.warn("unknown user");
		}

		return (user != null ? user.getLastName() : "???");
	}

	public void view(Long id) {
		logger.debug("view:" + id);
		CareGiverModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_VIEW);
		}
	}

	public void viewPF() {
		logger.debug("viewPF");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_VIEW_PF);
	}

	public void edit(Long id) {
		logger.debug("edit:" + id);
		CareGiverModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_EDIT);
		}
	}

	public void edit() {
		logger.debug("edit");
		logger.debug(model);
		view.setViewMode(ViewMode.VM_EDIT);
	}

	public void delete(Long id) {
		CareGiverModelBean bean = find(id);
		if (bean != null) {
			view.setViewMode(ViewMode.VM_DELETE);
		}
	}

	public void delete() {
		logger.debug("delete");
		logger.debug(model);

		HealthCareProviderDTO dto = converter.convertToDto(model);

		HealthCareProviderResponse r = dao.delete(dto);

		view.updateModel();

		view.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void save() {
		logger.debug("save");
		logger.debug(model);

		HealthCareProviderDTO dto = converter.convertToDto(model);

		HealthCareProviderResponse r = dao.save(dto);

		model.setCareGiverId(r.getHealthCareProviderDTO().getHealthCareProviderId());

		logger.debug(model);

		view.updateModel();

		view.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void saveAndAddNew() {
		logger.debug("saveAndAddNew");
		// TODO: check validation
		save();
		model.clearProperties();
		model.setCareGiverId(null);
		model.setProviderType("Specialist");
	}

	public void addNew() {
		logger.debug("addNew");
		model.clearProperties();
		model.setUserProfileId(9712240L);
		model.setProviderType("Specialist");
		view.setViewMode(ViewMode.VM_ADD);
	}

	public void cancel() {
		logger.debug("cancel");
		view.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void reset() {
		logger.debug("reset");
		model.clearProperties();
	}

	public void showPrinterFriendly() {
		logger.debug("showPrinterFriendly");
		logger.debug(view);
		view.setViewMode(ViewMode.VM_SUMMARY_PF);
	}

	private CareGiverModelBean find(Long id) {
		CareGiverModelBean bean = null;

		for (CareGiverModelBean m : view.getViewList()) {
			logger.debug(m);
			if (m.getCareGiverId().equals(id)) {
				bean = m;
				model.setProperties(m);
				break;
			}
		}
		logger.debug(bean == null ? id + " not found" : id + " found");

		return bean;
	}

}
