package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.web.common.ViewMode;

import java.io.Serializable;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class HealthCalendarViewBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private static Logger logger = LogManager.getLogger(HealthCalendarViewBean.class);
	
	private String viewMode = ViewMode.VM_SUMMARY;

	public String getViewMode() {
		return viewMode;
	}

	public void setViewMode(String viewMode) {
		logger.debug("viewMode=" + viewMode);
		this.viewMode = viewMode;
	}

	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
	}
}
