package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.web.common.ViewMode;

import java.io.Serializable;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("request")
public class HealthCalendarController implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthCalendarController.class);

	@Autowired
	private TreatmentLocationsViewBean viewBean;

	public void cancel() {
		logger.debug("cancel");
		viewBean.setViewMode(ViewMode.VM_SUMMARY);
	}

	public void showPrinterFriendly() {
		logger.debug("showPrinterFriendly");
		viewBean.setViewMode(ViewMode.VM_SUMMARY_PF);
	}
	
	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
	}

}
