package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.web.converter.HealthInsuranceConverter;
import gov.va.med.mhv.getcare.web.dao.HealthInsuranceDao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("request")
public class CoverageDashboardViewBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(CoverageDashboardViewBean.class);

	@Autowired
	private HealthInsuranceDao dao;

	@Autowired
	private HealthInsuranceConverter converter;

	private List<HealthInsuranceModelBean> viewList = new ArrayList<HealthInsuranceModelBean>();

	public List<HealthInsuranceModelBean> getViewList() {
		return viewList;
	}

	public void updateModel() {
		List<HealthInsuranceDTO> dtoList = null;

		viewList.clear();
		
		dtoList = dao.findByProfileId("9712240");

		for (HealthInsuranceDTO dto : dtoList) {
			logger.debug(dto);
			HealthInsuranceModelBean cg = converter.convert(dto);
			viewList.add(cg);
		}
		
		if (logger.isDebugEnabled()) {
			if (viewList != null) {
				logger.debug("Found records:" + viewList.size());
				logger.debug(Arrays.toString(viewList.toArray()));
			} else {
				logger.debug("No records found");
			}
		}
	}	

	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
		updateModel();
	}
}
