package gov.va.med.mhv.getcare.web.bean;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.web.converter.CareGiverConverter;
import gov.va.med.mhv.getcare.web.dao.HealthCareProviderDao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("request")
public class CareProvidersDashboardViewBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(CareProvidersDashboardViewBean.class);

	@Autowired
	private HealthCareProviderDao healthCareProviderDao;

	@Autowired
	private CareGiverConverter careGiverConverter;

	private List<CareGiverModelBean> viewList = new ArrayList<CareGiverModelBean>();
	private List<CareGiverModelBean> viewShortList = new ArrayList<CareGiverModelBean>();

	public List<CareGiverModelBean> getViewList() {
		return viewList;
	}

	public List<CareGiverModelBean> getViewShortList() {
		return viewShortList;
	}

	public void updateModel() {
		List<HealthCareProviderDTO> dtoList = null;

		viewList.clear();
		
		dtoList = healthCareProviderDao.findByProfileId("9712240");

		for (HealthCareProviderDTO dto : dtoList) {
			logger.debug(dto);
			CareGiverModelBean cg = careGiverConverter.convert(dto);
			viewList.add(cg);
		}
		updateShortList();
	}
	
	private void updateShortList() {
		viewShortList.clear();
		
		if (viewList == null || viewList.size() == 0) {
			return;
		}

		// put primary at top of list
		for (CareGiverModelBean c : viewList) {
			if (c.getProviderType().equals("Primary")) {
				viewShortList.add(c);
			}
		}

		//  add up to 5 providers
		for (CareGiverModelBean c : viewList) {
			if (!c.getProviderType().equals("Primary")) {
				viewShortList.add(c);
			}
			
			if (viewShortList.size() >= 5) {
				break;
			}
		}
	}

	@PostConstruct
	private void init() {
		logger.debug("postConstruct");
		updateModel();
	}
}
