package gov.va.med.mhv.getcare.web.bean;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class CareGiverModelBean implements Serializable {
	private static final long serialVersionUID = 1L;

	private Long userProfileId;
	private Long careGiverId;
	private String firstName;
	private String lastName;
	private String providerType; //Primary, Specialist, Dentist, Eye, Other Clinician
	private String otherClinician;
	private String workPhone;
	private String workPhoneExt;
	private String emailAddress;
	private String comments;
	
	public Long getUserProfileId() {
		return userProfileId;
	}
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	public Long getCareGiverId() {
		return careGiverId;
	}
	public void setCareGiverId(Long careGiverId) {
		this.careGiverId = careGiverId;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getFullName() {
		String fullName = "";
		if( this.firstName != null )
			fullName = fullName + this.firstName;
		
		if( lastName != null )
			fullName = fullName + " " + this.lastName;
		return fullName;
	}
	
	public String getFullPhoneNumber() {
		String full = "";
		if( this.workPhone != null )
			full = this.workPhone;
		
		if( this.workPhoneExt != null )
			full = full + " x" + this.workPhoneExt;
		
		return full;
	}

	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getProviderType() {
		return providerType;
	}
	public void setProviderType(String providerType) {
		this.providerType = providerType;
	}
	public String getOtherClinician() {
		return otherClinician;
	}
	public void setOtherClinician(String otherClinician) {
		this.otherClinician = otherClinician;
	}

	public String getWorkPhone() {
		return workPhone;
	}
	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}
	public String getWorkPhoneExt() {
		return workPhoneExt;
	}
	public void setWorkPhoneExt(String workPhoneExt) {
		this.workPhoneExt = workPhoneExt;
	}
	public String getEmailAddress() {
		return emailAddress;
	}
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	
	public void clearProperties() {
		this.firstName = "";
		this.lastName = "";
		this.providerType = "";
		this.otherClinician = "";
		this.workPhone = "";
		this.workPhoneExt = "";
		this.emailAddress = "";
		this.comments = "";
		this.providerType = "";
	}
	
	public void setProperties(CareGiverModelBean cg) {
		this.userProfileId = cg.userProfileId;
		this.careGiverId = cg.careGiverId;
		this.firstName = cg.firstName;
		this.lastName = cg.lastName;
		this.providerType = cg.providerType;
		this.otherClinician = cg.otherClinician;
		this.workPhone = cg.workPhone;
		this.workPhoneExt = cg.workPhoneExt;
		this.emailAddress = cg.emailAddress;
		this.comments = cg.comments;
	}
	
	@Override
	public String toString() {
		return "CareGiverModelBean [careGiverId=" + careGiverId
				+ ", firstName=" + firstName + ", lastName=" + lastName
				+ ", providerType=" + providerType + ", otherClinician="
				+ otherClinician + ", workPhone=" + workPhone
				+ ", workPhoneExt=" + workPhoneExt + ", emailAddress="
				+ emailAddress + ", comments=" + comments + ", userProfileId="
				+ userProfileId + "]";
	}

}