package gov.va.med.mhv.getcare.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.FacilityDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.WellnessPreferenceDTO;
import gov.va.med.mhv.getcare.common.dto.WellnessReminderDTO;
import gov.va.med.mhv.getcare.service.WellnessReminderService;
import gov.va.med.mhv.getcare.util.CommonUtility;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

@ManagedBean
@Component
@Scope("session")
public class WellnessReminderController extends AbstractController {

	private static final long serialVersionUID = 9050946863612105316L;
	private static Logger log = LogManager.getLogger(WellnessReminderController.class);
	private static final String WR_FAC_EXTRACT_STATUS = "WellnessReminders";
	private static final String WR_DETAIL_PAGE = "wellnessRemindersDetail";
	private static final String WR_UNRESOLVED_SUMMARY_PAGE = "wellnessRemindersUnresolvedList";
	private static final String WR_UNRESOLVED_SUMMARY_PRINT_PAGE = "wellnessRemindersUnresolvedListPrint";
	private static final String WR_RESOLVED_SUMMARY_PAGE = "wellnessRemindersResolvedList";
	private static final String WR_RESOLVED_SUMMARY_PRINT_PAGE = "wellnessRemindersResolvedListPrint";
	private static final String WR_PREFERENCES_PAGE = "wellnessRemindersPreferences";
	private static final String LOC_REQUIRED = "You must select at least one location to receive Wellness Reminders.";

	private String lastupdatedDate;
	private Boolean showUpdatingMsg = true;
	private List<String> pastDueMessagesList = new ArrayList<String>();
	private List<WellnessReminderDTO> unresolvedWellnessReminders = new ArrayList<WellnessReminderDTO>();
	private List<WellnessReminderDTO> resolvedWellnessReminders = new ArrayList<WellnessReminderDTO>();
	private WellnessReminderDTO selectedwellnessReminder;
	private DataTable wrTable = new DataTable();
	/*private List<String> availableFacilities;
	private List<String> selectedFacilities;*/
	private List<String> selectedFacilityIds;
	private Map<String, String> availableFacilitiesMap;
	private String returnPage;
	
	private String patientIcn ;
	private Long patientId;

	
	@Resource(name = "wellnessReminderServiceProxy")
	private WellnessReminderService wellnessReminderService;
	
	@Resource(name="userMgmtServiceProxy")
	private UserMgmtService userMgmtService;
	
	public void loadReminders(ComponentSystemEvent event) {
		String fromPage = (String) event.getComponent().getAttributes().get("fromPage");
		
		resetMessages();
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		FacesContext context = FacesContext.getCurrentInstance();
		if (request.getUserPrincipal() == null) {
			if (log.isDebugEnabled()) {
				log.debug("user not logged in...");
			}
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "/views/common/uanuthorized.xhtml");
		} else {
			if (session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE) != null) {
				String accountType = (String) session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE);
				if (accountType.equals("Premium")) {
					getWellnessRemainders(fromPage);
					if (!FacesContext.getCurrentInstance().isPostback()) {
						setRowsPerPage(10);
					} else {
						if(sortColumn != null && sortBy != null){
							wrTable.setValueExpression("sortBy", sortColumn);
							wrTable.setSortOrder(sortBy);
						} 
					}
				} else {
					context.getApplication().getNavigationHandler().handleNavigation(context, null, "/views/wellnessreminders/basicAdvancedMessage.xhtml");
				}
			} else {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "/views/wellnessreminders/basicAdvancedMessage.xhtml");
			}
		}
	}

	private void getWellnessRemainders(String fromPage) {
		try {
			findUser();
			patientId = getPatientIdFromSession();
			patientIcn = getPatientICNFromSession();

			refreshWellnessReminderData();
			getRefreshStatus();
			
			if (null != fromPage && fromPage.equalsIgnoreCase(WR_RESOLVED_SUMMARY_PAGE)) {
				resolvedWellnessReminders = findResolvedWellnessReminders(patientId);
			} else {
				unresolvedWellnessReminders = findUnresolvedWellnessReminders(patientId);
			}
		} catch (Exception e) {
			log.error("Error in Finding VA WellnessRemainders" + e);
			WebServiceClientUtil.showErrorMessage();
		}
	}
	
	private List<WellnessReminderDTO> findUnresolvedWellnessReminders(Long patientId) {
		List<String> pastDueMessagesList = new ArrayList<String>();
		
		if (null != patientId) {
			try {
				unresolvedWellnessReminders = wellnessReminderService.getUnresolvedStatusWellnessReminders(patientId);
			}  catch(MHVException e){
	        	log.error("Error in findUnresolvedWellnessReminders", e);
	        	super.processErrorMessages(e);
	        } catch (Exception e) {
				log.error("Error in fetching findUnresolvedWellnessReminders", e);
				throw new RuntimeException("Error in fetching findUnresolvedWellnessReminders", e);
			}
			
			if (null != unresolvedWellnessReminders && unresolvedWellnessReminders.size() > 0) {
				for (WellnessReminderDTO reminder : unresolvedWellnessReminders) {
					pastDueMessagesList.add(reminder.getSubject());
				}
				setPastDueMessagesList(pastDueMessagesList);
			}
		} else {
			log.error("PatientId is null");
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return unresolvedWellnessReminders;
	}

	private List<WellnessReminderDTO> findResolvedWellnessReminders(Long patientId) {
		if (null != patientId) {
			try {
				resolvedWellnessReminders = wellnessReminderService.getResolvedStatusWellnessReminders(patientId);
			}  catch(MHVException e){
	        	log.error("Error in findResolvedWellnessReminders", e);
	        	super.processErrorMessages(e);
	        } catch (Exception e) {
				log.error("Error in fetching findResolvedWellnessReminders", e);
				throw new RuntimeException("Error in fetching findResolvedWellnessReminders", e);
			}
		} else {
			log.error("PatientId is null");
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return resolvedWellnessReminders;
	}

	/*public List<WellnessReminderDTO> fetchWellnessReminders(Long patientId, String servicePath) {
		List<WellnessReminderDTO> dtoList = null;
		Reader responseReader = null;
		Gson gson = getGsonTimeStamp();
		
		WebClient client = getWebClient().path(servicePath).path(patientId).accept(CONTENT_TYPE);
		Response webserviceResponse = client.get();
		
		if (webserviceResponse.getStatus() == 200) {
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
			if (response.isSuccess()) {
				String jsonStr = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<WellnessReminderDTO>>() {}.getType();
				dtoList = gson.fromJson(jsonStr, type);

				log.debug("WellnessReminder  Records :" + dtoList.size());
			} else {
				log.error("Error in Find WellnessReminder Records");
				WebServiceClientUtil.showErrorMessage();
			}
		} else {
			throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
		
		return dtoList;
	}*/
	
	private void refreshWellnessReminderData() throws MHVException {
		WebClient client= getPHRManagerWebClient().path("refresh").path(patientIcn).path("WellnessReminders").
				         accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse=client.post(null);
		if(webserviceResponse.getStatus() == 200){
			log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
		}else{
			log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
	}

	
	
	public String getRefreshStatus() {
		log.debug("Inside  PHR-status service");
		
		
		if (patientId != null) {
			GsonBuilder builder = new GsonBuilder();
			builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() {
				@Override
				public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
						throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong());
				}
			});
			Gson gson = builder.create();
			WebClient client = getPHRManagerWebClient().path("status").path(patientIcn).accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			Response webserviceResponse = client.get();
			
			if (webserviceResponse.getStatus() == 200) {
				Reader responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				PatientExtractStatus patientExtractStatus = gson.fromJson(responseReader, PatientExtractStatus.class);
				String FacilityExtractStatusjson = gson.toJson(patientExtractStatus.getFacilityExtractStatusList());
				Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				Gson gson1 = new Gson();
				
				Date lastModified = null;
				
				List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				for (FacilityExtractStatus extractStatus : facilityStausList) {
					if (extractStatus.getExtract().trim().equals(WR_FAC_EXTRACT_STATUS)) {
						lastModified = extractStatus.getLastModified();
						if(lastModified == null){
							break;
						}
					}
				}

				if (lastModified != null) {
					lastupdatedDate = CommonUtility.dateToStringTimeZone(lastModified, "MM/dd/yyyy") + " at "
							+ CommonUtility.dateToStringTimeZone(lastModified, "HH:mm");
					unresolvedWellnessReminders = findUnresolvedWellnessReminders(patientId);
					resolvedWellnessReminders = findResolvedWellnessReminders(patientId);
				}

			} else {
				log.error("Error invoking PHR status service::" + WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			}
		}
		return null;
	}
	
	public String showWellnessReminderDetailPage(WellnessReminderDTO wellnessReminder){
		try {
			returnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");
			setShowUpdatingMsg(false);
			selectedwellnessReminder = wellnessReminder;
		} catch (Exception e) {
			log.error("Error in showWellnessReminderDetailPage", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return WR_DETAIL_PAGE;
	}
	
	public String printerFriendlyWRUnresolvedSummary() {
		wrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("wellRemForm:reminderList");
		return WR_UNRESOLVED_SUMMARY_PRINT_PAGE;
	}
	
	public String printerFriendlyWRResolvedSummary() {
		wrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("wrResolvedForm.reminderList");
		return WR_RESOLVED_SUMMARY_PRINT_PAGE;
	}
	
	public String showResolvedReminderSummaryPage() {
		return WR_RESOLVED_SUMMARY_PAGE;
	}
	
	public String showUnresolvedReminderSummaryPage() {
		return WR_UNRESOLVED_SUMMARY_PAGE;
	}
	
	public String showPreferences() {
		PatientDTO patientDto = null;
		List<WellnessPreferenceDTO> wellnessPreferences = null;
		selectedFacilityIds = new ArrayList<String>();
		availableFacilitiesMap = new LinkedHashMap<String, String>();
		
		try {
			returnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");
			
			patientDto = userMgmtService.getPatient(getUserProfileIdFromSession());
			
			if (null != patientDto && null != patientDto.getFacilities() && patientDto.getFacilities().size() > 0) {
				for (FacilityDTO facilityDto : patientDto.getFacilities()) {
					availableFacilitiesMap.put(facilityDto.getFacilityInfo().getName(), facilityDto.getFacilityInfoId().toString());
				}
			}
			
			wellnessPreferences = wellnessReminderService.getWellnessPreferencesByPatientId(patientDto.getId());
			if (null != wellnessPreferences && wellnessPreferences.size() > 0) {
				for (WellnessPreferenceDTO preference : wellnessPreferences) {
					selectedFacilityIds.add(preference.getFacilityInfoId().toString());
				}
			}
		} catch(MHVException e) {
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		} catch (Exception e) {
			log.error("Error in showPreferences", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return WR_PREFERENCES_PAGE;
	}
	
	public String savePreferences() {
		log.info("inside savePreferences()=============");
		resetMessages();
		
		if (null != selectedFacilityIds && selectedFacilityIds.size() == 0) {
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, LOC_REQUIRED, LOC_REQUIRED));
			return WR_PREFERENCES_PAGE;
		}
		
		Map<String, FacilityDTO> availableFacilitiesMap = new LinkedHashMap<String, FacilityDTO>();
		WellnessPreferenceDTO newPreference;
		try {
			// delete existing preferences from database
			wellnessReminderService.deleteWellnessPreferencesByPatientId(getPatientIdFromSession());
			
			PatientDTO patientDto = userMgmtService.getPatient(getUserProfileIdFromSession());
			
			if (null != patientDto && null != patientDto.getFacilities() && patientDto.getFacilities().size() > 0) {
				for (FacilityDTO facilityDto : patientDto.getFacilities()) {
					availableFacilitiesMap.put(facilityDto.getFacilityInfoId().toString(), facilityDto);
				}
			}
			
			//selectedFacilityIds
			for (String facId : selectedFacilityIds) {
				
				newPreference = new WellnessPreferenceDTO();
				
				FacilityDTO facDto = availableFacilitiesMap.get(facId);
				
				newPreference.setPatientId(patientDto.getId());
				newPreference.setFacilityInfoId(facDto.getFacilityInfoId());
				newPreference.setFacilityInfo(facDto.getFacilityInfo());
				Long phrFacilityControlId = wellnessReminderService.getPhrFacilityControlByFacilityId(facDto.getId());
				newPreference.setPhrFacilityControlId(phrFacilityControlId);
				
				wellnessReminderService.saveWellnessPreference(newPreference);
				
				setSaveMessage(true);
			}
		} catch(MHVException e) {
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		} catch (Exception e) {
			log.error("Error in savePreferences", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return WR_PREFERENCES_PAGE;
	}
	
	public String showReturnPage() {
		log.info("inside showReturnPage()=============");
		
		returnPage = (null != returnPage && returnPage.trim().length() > 0) ? returnPage : WR_UNRESOLVED_SUMMARY_PAGE;
		
		return returnPage;
	}
	
	/**
     * Determines if a refresh request for the extract type of this 
     * controller is currently in progress for the current patient.   
     * @return True if a request is in progress, otherwise false.
     * @see #getExtractType()
     * @see #getPatient()
     */
    public boolean getInProgress() {
    	//TODO: fix me - SRE
        //return (status != null) && BooleanUtils.isTrue(status.getInProgress());
    	//return true;
    	return false;
    }
	
	public String getLastupdatedDate() {
		return lastupdatedDate;
	}
	
	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}
	
	public boolean isShowUpdatingMsg() {
		return showUpdatingMsg;
	}
	
	public void setShowUpdatingMsg(boolean showUpdatingMsg) {
		this.showUpdatingMsg = showUpdatingMsg;
	}
	
	public List<String> getPastDueMessagesList() {
		return pastDueMessagesList;
	}
	
	public void setPastDueMessagesList(List<String> pastDueMessagesList) {
		this.pastDueMessagesList = pastDueMessagesList;
	}

	public List<WellnessReminderDTO> getUnresolvedWellnessReminders() {
		return unresolvedWellnessReminders;
	}
	
	public void setUnresolvedWellnessReminders(List<WellnessReminderDTO> unresolvedWellnessReminders) {
		this.unresolvedWellnessReminders = unresolvedWellnessReminders;
	}
	
	public DataTable getWrTable() {
		return (null == wrTable) ? new DataTable() : wrTable;
	}
	
	public void setWrTable(DataTable wrTable) {
		this.wrTable = wrTable;
	}
	
	public WellnessReminderDTO getSelectedwellnessReminder() {
		return selectedwellnessReminder;
	}
	
	public void setSelectedwellnessReminder(WellnessReminderDTO selectedwellnessReminder) {
		this.selectedwellnessReminder = selectedwellnessReminder;
	}
	
	/*public List<String> getAvailableFacilities() {
		return availableFacilities;
	}
	
	public void setAvailableFacilities(List<String> availableFacilities) {
		this.availableFacilities = availableFacilities;
	}
	
	public List<String> getSelectedFacilities() {
		return selectedFacilities;
	}
	
	public void setSelectedFacilities(List<String> selectedFacilities) {
		this.selectedFacilities = selectedFacilities;
	}*/
	
	public Map<String, String> getAvailableFacilitiesMap() {
		return availableFacilitiesMap;
	}
	
	public void setAvailableFacilitiesMap(Map<String, String> availableFacilitiesMap) {
		this.availableFacilitiesMap = availableFacilitiesMap;
	}
	
	public List<String> getSelectedFacilityIds() {
		return selectedFacilityIds;
	}
	
	public void setSelectedFacilityIds(List<String> selectedFacilityIds) {
		this.selectedFacilityIds = selectedFacilityIds;
	}
	
	public List<WellnessReminderDTO> getResolvedWellnessReminders() {
		return resolvedWellnessReminders;
	}
	
	public void setResolvedWellnessReminders(List<WellnessReminderDTO> resolvedWellnessReminders) {
		this.resolvedWellnessReminders = resolvedWellnessReminders;
	}
	
	public String getReturnPage() {
		return returnPage;
	}
	
	public void setReturnPage(String returnPage) {
		this.returnPage = returnPage;
	}
}