package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.service.TreatmentFacilityService;
import gov.va.med.mhv.getcare.web.compare.TreatmentFacilityDTOByNameCompare;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class TreatmentFacilitiesController extends AbstractController {
	private static final long serialVersionUID = 7168256787247834322L;
	private static Logger log = LogManager.getLogger(TreatmentFacilitiesController.class);

	private List<TreatmentFacilityDTO> facilities = new ArrayList<TreatmentFacilityDTO>();

	@Resource(name = "treatmentFacilityServiceProxy")
	private TreatmentFacilityService treatmentFacilityService;

	public void init(ComponentSystemEvent event) {
		try {
			log.debug("init");
			findUser();
			Long userprofileId = getUserProfileIdFromSession();
			if (userprofileId != null) {
				List<TreatmentFacilityDTO> unsortedFacilities = findFacilities(userprofileId);
				if (unsortedFacilities != null) {
					facilities = sortFacilites(unsortedFacilities);
				}
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	// sort facilities so that the home facility is at top
	private List<TreatmentFacilityDTO> sortFacilites(List<TreatmentFacilityDTO> facilities) {
		List<TreatmentFacilityDTO> sortedFacilities = new ArrayList<TreatmentFacilityDTO>(facilities);

		Collections.sort(sortedFacilities, new TreatmentFacilityDTOByNameCompare());

		// only display first five
		if (sortedFacilities.size() > 5) {
			sortedFacilities = sortedFacilities.subList(0, 5);
		}

		return sortedFacilities;
	}

	private List<TreatmentFacilityDTO> findFacilities(Long userprofileId) {
		List<TreatmentFacilityDTO> dtoList = null;
		try {
			dtoList = treatmentFacilityService.findFacilitiesForUser(userprofileId);
		} catch (MHVException e) {
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return dtoList;
	}

	public List<TreatmentFacilityDTO> getFacilities() {
		return facilities;
	}

	public void setFacilities(List<TreatmentFacilityDTO> facilities) {
		this.facilities = facilities;
	}

}
