package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.service.HealthInsuranceService;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class MyCoverageController extends AbstractController {
	private static final long serialVersionUID = 3645072846051540600L;
	private static Logger log = LogManager.getLogger(MyCoverageController.class);

	private List<HealthInsuranceDTO> insurances = new ArrayList<HealthInsuranceDTO>();

	@Resource(name = "healthInsuranceServiceProxy")
	private HealthInsuranceService healthInsuranceService;

	public void init(ComponentSystemEvent event) {
		try {
			findUser();
			userprofileId = getUserProfileIdFromSession();
			loadModel();
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	private void loadModel() {
		List<HealthInsuranceDTO> dtoList = null;
		try {
			Long userProfileId = getUserProfileIdFromSession();

			if (userProfileId == null) {
				insurances.clear();
				return;
			}

			dtoList = healthInsuranceService.findDashBoardInsurancesForUser(userprofileId);

			if (dtoList != null) {
				insurances = dtoList;
			} else {
				insurances.clear();
			}

		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	public List<HealthInsuranceDTO> getInsurances() {
		return insurances;
	}

	public void setInsurances(List<HealthInsuranceDTO> insurances) {
		this.insurances = insurances;
	}

}
