package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.service.HealthInsuranceService;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class HealthInsuranceController extends AbstractController {
	private static final long serialVersionUID = 363698377365833843L;
	private static Logger log = LogManager.getLogger(HealthInsuranceController.class);

	private static final String SAVE_MESSAGE = "Your last entry has been recorded in the table below.";
	private static final String SAVEADD_MESSAGE = "Your last entry has been recorded, and you may now add another new entry.";
	private static final String DELETE_MESSAGE = "You have successfully deleted an entry from the table below.";
	
	private DataTable insuranceTable;

	private List<HealthInsuranceDTO> insurances = new ArrayList<HealthInsuranceDTO>();
	private HealthInsuranceDTO selectedInsurance = new HealthInsuranceDTO();
	private HealthInsuranceDTO newInsurance = new HealthInsuranceDTO();

	@Resource(name = "healthInsuranceServiceProxy")
	private HealthInsuranceService healthInsuranceService;
	
	public void init(ComponentSystemEvent event) {
		try {
			log.debug("init");
			findUser();
			userprofileId = getUserProfileIdFromSession();
			insuranceTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("insuranceForm:insuranceList");
			
			if (!FacesContext.getCurrentInstance().isPostback()) {
				log.debug("Not postback");
				loadModel();
				setRowsPerPage(10);
			} else {
				log.debug("postback");
				if (sortColumn != null && sortBy != null) {
					insuranceTable.setValueExpression("sortBy", sortColumn);
					insuranceTable.setSortOrder(sortBy);
				}
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}
	
	private void loadModel() {
		List<HealthInsuranceDTO> dtoList = null;
		try {
			Long userProfileId = getUserProfileIdFromSession();
			dtoList = healthInsuranceService.findInsurancesForUser(userProfileId);
			if (dtoList != null) {
				insurances = dtoList;
			} else {
				insurances.clear();
			}
		} catch(MHVException e){
			log.error(e);
        	super.processErrorMessages(e);
        } catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}		
	}

	public void onSort(SortEvent event) {
		sortColumn = event.getSortColumn().getValueExpression("sortBy");
		sortBy = event.isAscending() ? "ascending" : "descending";
	}

	public String showDetail(HealthInsuranceDTO insurance) {
		selectedInsurance = insurance;
		return "healthInsurance";
	}

	public String editDisplay(HealthInsuranceDTO insurance) {
		selectedInsurance = insurance;
		return "editHealthInsuranceDisplay";
	}

	public String deleteDisplay(HealthInsuranceDTO insurance) {
		selectedInsurance = insurance;
		setDeleteOrigin("tableView");
		return "deleteHealthInsuranceDisplay";
	}

	public String deleteRecordDisplay() {
		setDeleteOrigin(null);
		return "deleteHealthInsuranceDisplay";
	}

	public String addDisplay() {
		newInsurance = new HealthInsuranceDTO();
		newInsurance.setStartDate(new Date());
		return "addHealthInsuranceDisplay";
	}

	public String printerFriendlySummary() {
		insuranceTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot()
				.findComponent("insuranceForm:insuranceList");
		return "printHealthInsuranceSummary";
	}

	public String save() {
		String outcome = null;
		try {
			ResponseUtil response = saveInsurance();
			if (response.isSuccess()) {
				loadModel();
				outcome = "healthInsuranceList";
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, SAVE_MESSAGE, SAVE_MESSAGE));
			} else {
				super.processErrorMessages(response);
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
		return outcome;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			ResponseUtil response = saveInsurance();
			if (response.isSuccess()) {
				loadModel();
				outcome = "addHealthInsuranceDisplay";
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, SAVEADD_MESSAGE, SAVEADD_MESSAGE));
				newInsurance = new HealthInsuranceDTO();
				newInsurance.setStartDate(new Date());
			} else {
				super.processErrorMessages(response);
			}

		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public String backToList() {
		return "healthInsuranceList";
	}

	public String dashboardAddDisplay() throws MHVException {
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileIdFromSession();
		loadModel();
		newInsurance = new HealthInsuranceDTO();
		newInsurance.setStartDate(new Date());
		return "/views/healthinsurance/addHealthInsuranceDisplay";
	}
	
	public String dashboardViewMore() throws MHVException {
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileIdFromSession();
		loadModel();
		return "/views/healthinsurance/healthInsuranceList";
	}

	public String showDahBoardDetail() throws MHVException {
		findUser();
		String insuranceid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap()
				.get("insuranceid");
		if (insuranceid != null) {
			Long id = Long.valueOf(insuranceid);
			selectedInsurance = findInsuranceById(id);
		}
		return "/views/healthinsurance/healthInsurance";
	}
	
	private HealthInsuranceDTO findInsuranceById(Long id) {
		HealthInsuranceDTO dto = null;

		try {
			dto = healthInsuranceService.findByPrimaryKey(id);
		} catch(MHVException e){
			log.error(e);
        	super.processErrorMessages(e);
        } catch (Exception e) {
			log.error(e);
	    	WebServiceClientUtil.showErrorMessage();
		}

		return dto;
	}

	public String delete() {
		String outcome=null;
		String insuranceid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("insuranceid");
		ResponseUtil response = new ResponseUtil();
		try{
			if (insuranceid != null) {
				Long id = Long.valueOf(insuranceid);
				response = healthInsuranceService.delete(id);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Insurance" ,response.getFailureMessage());
					WebServiceClientUtil.showErrorMessage();
				} else {
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, DELETE_MESSAGE, DELETE_MESSAGE));
					loadModel();
					outcome="healthInsuranceList";
				}
			}
		} catch(MHVException e){
			log.error(e);
        	super.processErrorMessages(e);
        } catch(Exception e){
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public ResponseUtil saveInsurance() throws MHVException {
		ResponseUtil response = new ResponseUtil();
		String insuranceid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("insuranceid");
		HealthInsuranceDTO insurance = null;
		
		if (insuranceid != null) {
			insurance = getSelectedInsurance();
		} else {
			insurance = getNewInsurance();
		}
		insurance.setUserProfileId(getUserProfileIdFromSession());
		
		try {
			response = healthInsuranceService.save(insurance);
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		}
		
		return response;
	}

	private HealthInsuranceDTO prepareInsurance(HealthInsuranceDTO insurance) throws MHVException {
		insurance.setUserProfileId(getUserProfileIdFromSession());
		return insurance;
	}

	public List<HealthInsuranceDTO> getInsurances() {
		return insurances;
	}

	public void setInsurances(List<HealthInsuranceDTO> insurances) {
		this.insurances = insurances;
	}

	public DataTable getInsuranceTable() {
		return insuranceTable;
	}

	public void setInsuranceTable(DataTable insuranceTable) {
		this.insuranceTable = insuranceTable;
	}

	public HealthInsuranceDTO getSelectedInsurance() {
		return selectedInsurance;
	}

	public void setSelectedInsurance(HealthInsuranceDTO selectedInsurance) {
		this.selectedInsurance = selectedInsurance;
	}

	public HealthInsuranceDTO getNewInsurance() {
		return newInsurance;
	}

	public void setNewInsurance(HealthInsuranceDTO newInsurance) {
		this.newInsurance = newInsurance;
	}

}
