package gov.va.med.mhv.getcare.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.getcare.common.dto.AppointmentDTO;
import gov.va.med.mhv.getcare.service.AppointmentService;
import gov.va.med.mhv.getcare.util.CommonUtility;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

@ManagedBean
@Component
@Scope("session")
public class AppointmentController extends AbstractController {

	private static final long serialVersionUID = 9050946863612105316L;
	private static Logger log = LogManager.getLogger(AppointmentController.class);

	private List<AppointmentDTO> appointments = new ArrayList<AppointmentDTO>();
	private DataTable aptTable = new DataTable();
	private AppointmentDTO selectedAppointment= new AppointmentDTO();
	private String lastupdatedDate;
	private String patientIcn ;
	private Long patientId;


	@Value("${varendpointUrl}")
	private String varUrl = null;

	@Resource(name = "appointmentServiceProxy")
	private AppointmentService appointmentService;

	@Resource
	private AccountActivityCreatorService activityProxy;

	public void init(ComponentSystemEvent event) {
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session =request.getPortletSession();
		FacesContext context = FacesContext.getCurrentInstance();
		aptTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("appointmentForm:appointmentList");
		if(session.getAttribute("LIFERAY_SHARED_accountType",PortletSession.APPLICATION_SCOPE) != null){
			String accountType =(String)session.getAttribute("LIFERAY_SHARED_accountType",PortletSession.APPLICATION_SCOPE);
			if(accountType.equals("Premium") ||accountType.equals("Advanced") ){
				if(!FacesContext.getCurrentInstance().isPostback()){
					getAppointmentRecords();
					setRowsPerPage(10);
					//TODO: are you VAR Eligible
				//	checkVAREligible();
				}else{
					if(sortColumn != null && sortBy != null){
						aptTable.setValueExpression("sortBy", sortColumn);
						aptTable.setSortOrder(sortBy);
					} 
				}
			}else{
				context.getApplication().getNavigationHandler().
				handleNavigation(context, null, "/views/appointments/basicAdvancedMessage.xhtml");
			}
		}else{
			context.getApplication().getNavigationHandler().
			handleNavigation(context, null, "/views/appointments/basicAdvancedMessage.xhtml");
		}
	}


	private void getAppointmentRecords(){
		try {
			findUser();
			patientId = getPatientIdFromSession();
			patientIcn = getPatientICNFromSession();

			refreshAllergyData();
			getRefreshStatus();
			appointments = findAppointments(patientId);
		} catch(Exception e) {
			log.error("Error in getAppointmentRecords::"+ e.getMessage());
			WebServiceClientUtil.showErrorMessage();
		}
	}

	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}	

	private void refreshAllergyData() throws MHVException {
		
		WebClient client= getPHRManagerWebClient().path("refresh").path(patientIcn).path("Appointments").
				accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse=client.post(null);
		if(webserviceResponse.getStatus() == 200){
			log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
		}else{
			log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
	}


	public String getRefreshStatus(){
		log.debug("Inside  PHR-status service");
		if(patientId != null){
			GsonBuilder builder = new GsonBuilder(); 
			builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() { 
				@Override
				public Date deserialize(JsonElement json, Type typeOfT,
						JsonDeserializationContext context)
								throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong()); 
				} 
			});
			Gson gson = builder.create();
			WebClient client= getPHRManagerWebClient().path("status").path(patientIcn).
					accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			Response webserviceResponse =client.get();
			Date lastModified=null; 
			if(webserviceResponse.getStatus() == 200){
				Reader responseReader= new InputStreamReader ((InputStream)webserviceResponse.getEntity());
				PatientExtractStatus patientExtractStatus= gson.fromJson(responseReader,PatientExtractStatus.class);
				String FacilityExtractStatusjson=gson.toJson(patientExtractStatus.getFacilityExtractStatusList()) ;   
				Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				Gson gson1= new Gson();
				List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				for(FacilityExtractStatus extractStatus : facilityStausList){
					if(extractStatus.getExtract().trim().equals("Appointments")){
						lastModified = extractStatus.getLastModified();
						break;
					}
				}
				if(lastModified != null){
					lastupdatedDate=CommonUtility.dateToStringTimeZone(lastModified,"MM/dd/yyyy") +
							"  at  "+CommonUtility.dateToStringTimeZone(lastModified,"HH:mm"); 
					appointments = findAppointments(patientId);
				}

			}else{
				log.error("Error invoking PHR status service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			}
		}
		return null;
	}


	private List<AppointmentDTO> findAppointments(Long patientId) {
		List<AppointmentDTO> dtoList = null;

		try {
			dtoList = appointmentService.findAppointmentsForPatient(patientId);
		} catch(MHVException e){
			log.error("Error in findAppointments", e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error("Error in fetching findAppointmentsForPatient", e);
			throw new RuntimeException("Error in fetching findAppointmentsForPatient", e);
		}

		return dtoList;
	}


	public String showDetail(AppointmentDTO appointment) {
		selectedAppointment = appointment;
		return "appointment";
	}

	public String getVarUrl() {
		System.out.println("About to set varUrl: " + varUrl);
		//varUrl ="https://vet-int.mobilehealth.DNS   /veteran-appointment-requests";
		return varUrl;
	}

	public String registervaraal() {
		try {
				activityProxy.createAccountActivityLog(
					ActivityHelper.createActivityDTOForSelf(
							getUserProfileIdFromSession(), true, 
							ActivityTypeEnumeration.APPOINTMENTS, 
							ActivityActionTypeEnumeration.ACCESS_VAR_MHV, "")
					);
		} catch (MHVException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return "hello";
	}

	public String printerFriendlySummary(){
		aptTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("appointmentForm:appointmentList");
		return "printAppointmentSummary";
	}


	public List<AppointmentDTO> getAppointments() {
		return appointments;
	}


	public void setAppointments(List<AppointmentDTO> appointments) {
		this.appointments = appointments;
	}


	public DataTable getAptTable() {
		return aptTable;
	}


	public void setAptTable(DataTable aptTable) {
		this.aptTable = aptTable;
	}


	public AppointmentDTO getSelectedAppointment() {
		return selectedAppointment;
	}


	public void setSelectedAppointment(AppointmentDTO selectedAppointment) {
		this.selectedAppointment = selectedAppointment;
	}


	public String getLastupdatedDate() {
		return lastupdatedDate;
	}


	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}
	
}
