package gov.va.med.mhv.getcare.web.controller;

import java.io.Serializable;
import java.util.Map;

import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.PropsUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

@PropertySources(value = {
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.application.properties"), 
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.properties"),
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.getcare.portlet.properties")
})
public abstract class AbstractController implements Serializable {

	private static final long serialVersionUID = -8611610134485398648L;
	private static Logger log = LogManager.getLogger(AbstractController.class);
	private String firstName;
	private String lastName;
	protected static final String  DEFAULT_HOUR ="23";
	protected static final String  DEFAULT_MINUTE ="59";
	protected static final String  DEFAULT_DATETIME ="23:59";
	protected static final String  HOUR_MINUTE ="HH:mm";
	protected static final String  HOURS ="HH";
	protected static final String  MINUTES ="mm";
	protected Boolean saveMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteMessage = false;
	protected String period;
	protected static final String  YYYYMMDD_FORMAT ="yyyyMMdd";
	protected static final String  YYYY_MM_DD_HHMMSS_FORMAT="yyyy-MM-dd";
	protected static final String CHART_EXTENDER="chartExtender";
	protected static final String DAYS ="dd";
	protected static final String MONTHS="MM";
	protected static final String YEARS="yyyy";
	protected static final String NO_DATA="No data available";
	protected static final String ERR_PRCS_RQST="Error Processing request";
	protected static final String CONTENT_TYPE="application/json";
	protected static final String authenticationHeader ="X-Authorization-Key";
	protected static final String PATIENT = "patient";
	private static final String USER_PROFILE_ID_KEY = "LIFERAY_SHARED_userprofileid";
	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	private static final String PATIENT_ID_KEY = "LIFERAY_SHARED_patientid";
	private static final String PATIENT_ICN_KEY = "LIFERAY_SHARED_patienticn";
	
	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;

	
	private String deleteOrigin;

	@Value("${endpointUrl}")
	private String endpointUrl;
	
	@Value("${usermgmtEndpointUrl}")
	private String userManagmentendpointUrl;
	
	@Value("${phrManagerendpointUrl}")
	private String phrManagerendpointUrl;

	@Value("${phrmgr.xauth.key}")
	private String authenticationHeaderValue;
	
	@Value("${appContextroot}")
	private String appContextRoot;
	
	@Autowired
	protected ObjectMapper mapper;

	protected WebClient getWebClient() {
	    log.debug("Health History endpoint##:");
	    log.debug(endpointUrl);
		return WebClient.create(endpointUrl);
	}
	
	protected WebClient getUserManagmentWebClient() {
	    log.debug("Usermanagement endpoint##:");
	    log.debug(userManagmentendpointUrl);
		return WebClient.create(getUserManagmentendpointUrl());
	}

	protected WebClient getPHRManagerWebClient() {
	    log.debug("PHR Manager endpoint##:");
	    log.debug(phrManagerendpointUrl);
		return WebClient.create(getPhrManagerendpointUrl());
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		return  context;
    }

	protected void findUser() throws MHVException {
		UserProfileDTO userProfileDto = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			PortletSession session = request.getPortletSession();
			String userStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfileDto = mapper.readValue(userStr, UserProfileDTO.class);

			if (null != userProfileDto) {
				setFirstName(userProfileDto.getName().getFirstName());
				setLastName(userProfileDto.getName().getLastName());
			}
		} catch (Exception e) {
			log.error("Error in getUserProfileId", e);
			throw new MHVException("Error in getUserProfileId", e);
		}
	}
	
	protected UserProfileDTO getUserProfileFromSession() throws MHVException {
		UserProfileDTO userProfileDto = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			PortletSession session = request.getPortletSession();

			String userStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfileDto = mapper.readValue(userStr, UserProfileDTO.class);

		} catch (Exception e) {
			log.error("Error in getUserProfileId", e);
			throw new MHVException("Error in getUserProfileId", e);
		}

		return userProfileDto;
	}
	
	protected Long getUserProfileIdFromSession() throws MHVException {
		Long userProfileId=0l;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			userProfileId = (Long)session.getAttribute(USER_PROFILE_ID_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get UserProfile Id from session");
		}
		return userProfileId;
	}
	
	protected Long getPatientIdFromSession() throws MHVException {
		Long patientId=0l;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			patientId = (Long)session.getAttribute(PATIENT_ID_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get Patient Id from session");
		}
		
		return patientId;
	}
	
	protected String getPatientICNFromSession() throws MHVException {
		String patientICN;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			patientICN = (String)session.getAttribute(PATIENT_ICN_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get Patient ICN from session");
		}
		return patientICN;
	}
	
	protected void resetMessages(){
		saveMessage = false;
		saveAndAddMessage = false;
		deleteMessage = false;
	}
	
	
	protected void processErrorMessages(ResponseUtil response) {
		log.info("isFailure : " + response.isFailure());
		// response has errors
		if (null != response && !response.isSuccess() || response.isFailure()) {
			Map<String, String> validationErrors = response.getValidationErrors();

			if (log.isDebugEnabled()) {
				int size = null != validationErrors ? validationErrors.size() : 0;
				log.debug("validationErrors.size() : " + size);
			}

			// check if there are any validation errors in response object
			if (null != validationErrors && validationErrors.size() > 0) {

				for (Map.Entry<String, String> err : validationErrors.entrySet()) {
					if (log.isDebugEnabled()) {
						if (null != err) {
							log.debug("entry.getKey() : " + err.getKey());
							log.debug("entry.getValue() : " + err.getValue());
						}
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
				}
			}

			// check for non-validation errors in response object
			if (null != response.getFailureMessage() && response.getFailureMessage().length() > 0) {
				if (log.isDebugEnabled()) {
					log.debug("FailureMessage : " + response.getFailureMessage());
				}

				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
	}
	
	protected void processErrorMessages(MHVException exp) {
		// response has errors
		if (null != exp.getErrorCode()) {
			Map<String, String> validationErrors = exp.getValidationErrorMessages();

			if (log.isDebugEnabled()) {
				int size = null != validationErrors ? validationErrors.size() : 0;
				log.debug("validationErrors.size() : " + size);
			}

			// check if there are any validation errors in response object
			if (null != validationErrors && validationErrors.size() > 0) {

				for (Map.Entry<String, String> err : validationErrors.entrySet()) {
					if (log.isDebugEnabled()) {
						if (null != err) {
							log.debug("entry.getKey() : " + err.getKey());
							log.debug("entry.getValue() : " + err.getValue());
						}
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
				}
			}

			// check for non-validation errors in response object
			if (null != exp.getFailureMessage() && exp.getFailureMessage().length() > 0) {
				if (log.isDebugEnabled()) {
					log.debug("FailureMessage : " + exp.getFailureMessage());
				}

				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}


	public String getDeleteOrigin() {
		return deleteOrigin;
	}



	public void setDeleteOrigin(String deleteOrigin) {
		this.deleteOrigin = deleteOrigin;
	}



	public String getUserManagmentendpointUrl() {
		return userManagmentendpointUrl;
	}


	public void setUserManagmentendpointUrl(String userManagmentendpointUrl) {
		this.userManagmentendpointUrl = userManagmentendpointUrl;
	}



	public String getPhrManagerendpointUrl() {
		return phrManagerendpointUrl;
	}



	public void setPhrManagerendpointUrl(String phrManagerendpointUrl) {
		this.phrManagerendpointUrl = phrManagerendpointUrl;
	}



	public String getAuthenticationHeaderValue() {
		return authenticationHeaderValue;
	}



	public void setAuthenticationHeaderValue(String authenticationHeaderValue) {
		this.authenticationHeaderValue = authenticationHeaderValue;
	}

	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}
}
