package gov.va.med.mhv.getcare.validator;

import java.text.MessageFormat;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.enums.StateEnumeration;
import gov.va.med.mhv.getcare.model.TreatmentFacility;
import gov.va.med.mhv.getcare.repository.TreatmentFacilityRepository;
import gov.va.med.mhv.getcare.util.MessagesUtil;

@Component
public class FacilityValidator  extends Validator {
	
	private static final int COMMENTS_MAX_LENGTH = 255;
	private static final int FACILITYNAME_MIN_LENGTH = 2;
	private static final int FACILITYNAME_MAX_LENGTH = 100;
	private static final int ADDRESS_MAX_LENGTH = 255;
	private static final int PROVINCE_MAX_LENGTH = 255;
	private static final int ZIPCODE_MAX_LENGTH = 10;
	private static final int WORK_PHONE_EXT_MAX_LENGTH = 255;
	private static final int CITY_MAX_LENGTH = 255;
	
	@Autowired
	private TreatmentFacilityRepository facilityRepository;
	
	@Autowired
	private MessagesUtil messages;

	
	public void facilityValidations(ResponseUtil response, TreatmentFacilityDTO facilityDTO) {
		fieldValidation(response, facilityDTO);
		if (response.getValidationErrors().size() == 0) {
			complexValidation(response, facilityDTO);
		}
	}

	private void complexValidation(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		validateSingleHomeFacilityHome(response,facilityDTO);
	}

	private void validateSingleHomeFacilityHome(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		if(facilityDTO.getHomeFacility()){
			List<TreatmentFacility> facilities=facilityRepository.findHomeFacility(facilityDTO.getUserProfileId());
			if(facilities != null && facilities.size() > 0){
				for(TreatmentFacility facility: facilities){
					String oldFacility=facility.getFacilityName();
					if(facilityDTO.getTreatmentFacilityId() != null){
					   if(facilityDTO.getTreatmentFacilityId().longValue() != facility.getTreatmentFacilityId().longValue()){
						   response.getValidationErrors().put("invalid home facility",
								   MessageFormat.format(messages.getInvalidHomeFacility(),oldFacility));
								   //messages.getInvalidHomeFacility());
						   break;	
					   }
					}else{
					    response.getValidationErrors().put("invalid home facility",
					    		MessageFormat.format(messages.getInvalidHomeFacility(),oldFacility));
					    		//messages.getInvalidHomeFacility());
						break;
					}
				}
			}
		}
		
		
	}

	private void fieldValidation(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		validateComments(response,facilityDTO);
		validateFacilityType(response,facilityDTO);
		validateFacilityName(response,facilityDTO);
		validateAddressStreet1(response,facilityDTO);
		validateAddressProvince(response,facilityDTO);
		validateAddressState(response,facilityDTO);
		validateAddressStreet2(response,facilityDTO);
		validateAddressPostalCode(response,facilityDTO);
		validateContactInfoWorkPhoneExtension(response,facilityDTO);
		validateAddressCountry(response,facilityDTO);
		validateAddressCity(response,facilityDTO);
		validateContactInfoWorkPhone(response,facilityDTO);
		validateHomeFacility(response,facilityDTO);
		validateContactInfoFax(response,facilityDTO);
		validateUserProfile(response,facilityDTO);
	}

	private void validateUserProfile(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		if( facilityDTO.getUserProfileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(facilityDTO.getUserProfileId() );
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
		
	}

	private void validateContactInfoFax(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getContactInfoFax();
		if ( value == null ) {
			return;
		}	
		Validations.validatePhoneNumber("Fax Number", value, response.getValidationErrors());
	}

	private void validateHomeFacility(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
	/*	Integer value;
		if(facilityDTO.getHomeFacility()){
			value = 1;
		}else{
			value=0;
		} */
		
	}

	private void validateContactInfoWorkPhone(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getContactInfoWorkPhone();
		if ( value == null ) {
			return;
		}	
		Validations.validatePhoneNumber("Phone Number", value, response.getValidationErrors());
	}

	private void validateAddressCity(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressCity();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("City",value, CITY_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateAddressCountry(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressCountry();
		if( value == null ) {
			return;
		}		
		//Validations.validateEnumeration("Country", value, CountryEnumeration.values(), response.getValidationErrors());
	}

	private void validateContactInfoWorkPhoneExtension(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getContactInfoWorkPhoneExt();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("Work Phone Extension",value, WORK_PHONE_EXT_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateAddressPostalCode(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressPostalCode();
		if ( value == null ) {
			return;
		}	
		Validations.validateMaxLength("Zip Code",value, ZIPCODE_MAX_LENGTH, response.getValidationErrors());
		Validations.validateZipCode("Zip Code", value, response.getValidationErrors());
	}

	private void validateAddressStreet2(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressStreet2();
		if ( value == null ) {
			return;
		}	
		Validations.validateMaxLength("Address 2",value, ADDRESS_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateAddressState(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressState();
		if( value == null ) {
			return;
		}		
		Validations.validateEnumeration("State", value, StateEnumeration.values(), response.getValidationErrors());
	}

	private void validateAddressProvince(ResponseUtil response,	TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressProvince();
		if ( value == null ) {
			return;
		}	
		Validations.validateMaxLength("Province",value, PROVINCE_MAX_LENGTH, response.getValidationErrors());
		
	}

	private void validateAddressStreet1(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getAddressStreet1();
		if ( value == null ) {
			return;
		}	
		Validations.validateMaxLength("Address 1",value, ADDRESS_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateFacilityName(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getFacilityName();
		if ( value == null ) {
			Validations.validateRequired("Facility Name", value, response.getValidationErrors());
			return;
		}	
		Validations.validateMinLength("Facility Name",value, FACILITYNAME_MIN_LENGTH, response.getValidationErrors());
		Validations.validateMaxLength("Facility Name",value, FACILITYNAME_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateFacilityType(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getFacilityType();
		if ( value == null ) {
			Validations.validateRequired("Facility Type", value, response.getValidationErrors());
			return;
		}		
	}

	private void validateComments(ResponseUtil response,TreatmentFacilityDTO facilityDTO) {
		String value = facilityDTO.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("Comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}
}
