package gov.va.med.mhv.getcare.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.transaction.Transactional;
import javax.ws.rs.PathParam;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.WellnessPreferenceDTO;
import gov.va.med.mhv.getcare.common.dto.WellnessReminderDTO;
import gov.va.med.mhv.getcare.converter.WellnessPreferenceConverter;
import gov.va.med.mhv.getcare.converter.WellnessReminderConverter;
import gov.va.med.mhv.getcare.model.WellnessPreference;
import gov.va.med.mhv.getcare.model.WellnessReminder;
import gov.va.med.mhv.getcare.repository.PhrFacilityControlRepository;
import gov.va.med.mhv.getcare.repository.WellnessPreferenceRepository;
import gov.va.med.mhv.getcare.repository.WellnessReminderRepository;
import gov.va.med.mhv.getcare.service.WellnessReminderService;

@Component
public class WellnessReminderServiceImpl implements WellnessReminderService {

	private static Logger log = LogManager.getLogger(WellnessReminderServiceImpl.class);
	
	@Autowired
	private WellnessReminderRepository wellnessReminderRepository;
	
	@Autowired
	private WellnessPreferenceRepository wellnessPreferenceRepository;
	
	@Autowired
	private PhrFacilityControlRepository phrFacilityControlRepository;
	
	@Autowired
	private WellnessReminderConverter wellnessReminderConverter;
	
	@Autowired
	private WellnessPreferenceConverter wellnessPreferenceConverter; 

	@Override
	public String test(@PathParam("sampleText") String sampleText) {
		return sampleText;
	}
	
	@Override
	public List<WellnessReminderDTO> getResolvedStatusWellnessReminders(Long patientId) throws MHVException {
		List<WellnessReminderDTO> reminderDtos = null;
		List<WellnessReminder> reminders = null;
		
		try {
			reminders = wellnessReminderRepository.getResolvedStatusWellnessRemindersByPatientId(patientId);

			if (null != reminders && reminders.size() > 0) {
				reminderDtos = new ArrayList<WellnessReminderDTO>();
				for (WellnessReminder reminder : reminders) {
					reminderDtos.add(wellnessReminderConverter.convert(reminder));
				}
			}
		} catch(Exception e) {
			log.error("Error in fetching ResolvedStatusWellnessReminders " + e);
			throw new MHVException("Error in fetching ResolvedStatusWellnessReminders", e);
		}
		
		return reminderDtos;
	}
	
	@Override
	public WellnessReminderDTO getWellnessReminderById(@PathParam("id") Long id) throws MHVException {
		WellnessReminderDTO reminderDto = null;
		WellnessReminder reminder = null;
		
		try {
			reminder = wellnessReminderRepository.findOne(id);

			if (null != reminder) {
				reminderDto = wellnessReminderConverter.convert(reminder);
			}
		} catch(Exception e) {
			log.error("Error in fetching getWellnessReminderById " + e);
			throw new MHVException("Error in fetching getWellnessReminderById", e);
		}
		
		return reminderDto;
	}

	@Override
	public List<WellnessReminderDTO> getUnresolvedStatusWellnessReminders(Long patientId) throws MHVException {
		List<WellnessReminderDTO> reminderDtos = null;
		List<WellnessReminder> reminders = null;
		
		try {
			reminders = wellnessReminderRepository.getUnresolvedStatusWellnessRemindersByPatientId(patientId);

			if (null != reminders && reminders.size() > 0) {
				reminderDtos = new ArrayList<WellnessReminderDTO>();
				for (WellnessReminder reminder : reminders) {
					reminderDtos.add(wellnessReminderConverter.convert(reminder));
				}
			}
		} catch(Exception e) {
			log.error("Error in fetching UnresolvedStatusWellnessReminders " + e);
			throw new MHVException("Error in fetching UnresolvedStatusWellnessReminders", e);
		}
		
		return reminderDtos;
	}

	@Override
	public List<WellnessPreferenceDTO> getWellnessPreferencesByPatientId(Long patientId) throws MHVException {
		List<WellnessPreferenceDTO> preferenceDtos = null;
		List<WellnessPreference> preferences = null;
		
		try {
			preferences = wellnessPreferenceRepository.getWellnessPreferencesByPatientId(patientId);

			if (null != preferences && preferences.size() > 0) {
				preferenceDtos = new ArrayList<WellnessPreferenceDTO>();
				for (WellnessPreference preference : preferences) {
					preferenceDtos.add(wellnessPreferenceConverter.convert(preference));
				}
			}
		} catch(Exception e) {
			log.error("Error in fetching getWellnessPreferencesByPatientId " + e);
			throw new MHVException("Error in fetching getWellnessPreferencesByPatientId", e);
		}
		
		return preferenceDtos;
	}

	@Override
	@Transactional
	public ResponseUtil deleteWellnessPreferencesByPatientId(Long patientId) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		try {
			List<WellnessPreference> prefs = wellnessPreferenceRepository.getWellnessPreferencesByPatientId(patientId);
			
			for (WellnessPreference pref : prefs) {
				/*FacilityControl facilityControl = phrFacilityControlRepository.findOne(pref.getPhrFacilityControlId());
				facilityControl.getPreferences().remove(pref);
				phrFacilityControlRepository.saveAndFlush(facilityControl);
				
				FacInfo facInfo = facInfoRepository.findOne(pref.getFacilityInfoId());
				facInfo.getPreferences().remove(pref);
				facInfoRepository.saveAndFlush(facInfo);
				
				Pat patient = patRepository.findOne(pref.getPatientId());
				patient.getPreferences().remove(pref);
				patRepository.saveAndFlush(patient);*/
				
				wellnessPreferenceRepository.deleteWellnessPreferencesByPatientId(patientId);
			}
			response.setSuccess(true);
		} catch(Exception e) {
			response.setSuccess(false);
			response.setFailure(true);
			log.error("Error in deleteWellnessPreferencesByPatientId " + e);
			throw new MHVException("Error in deleteWellnessPreferencesByPatientId", e);
		}
		
		return response;
	}
	
	@Override
	public ResponseUtil saveWellnessPreference(WellnessPreferenceDTO preferenceDto) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		WellnessPreference preference;
		try {
			preference = wellnessPreferenceConverter.convert(preferenceDto);
			
			wellnessPreferenceRepository.saveAndFlush(preference);
			
			response.setSuccess(true);
		} catch(Exception e) {
			response.setSuccess(false);
			response.setFailure(true);
			log.error("Error in saveWellnessPreference " + e);
			throw new MHVException("Error in saveWellnessPreference", e);
		}
		
		return response;
	}

	@Override
	public Long getPhrFacilityControlByFacilityId(Long facilityId) throws MHVException {
		Long phrFacilityCtrlId = null;
		try {
			phrFacilityCtrlId = phrFacilityControlRepository.findFacilityControlByFacilityId(facilityId);
		} catch(Exception e) {
			log.error("Error in getPhrFacilityControlByFacilityId " + e);
			throw new MHVException("Error in getPhrFacilityControlByFacilityId", e);
		}
		
		return phrFacilityCtrlId;
	}
}
