package gov.va.med.mhv.getcare.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.converter.HealthInsuranceConverter;
import gov.va.med.mhv.getcare.model.HealthInsurance;
import gov.va.med.mhv.getcare.repository.HealthInsuranceRepository;
import gov.va.med.mhv.getcare.service.HealthInsuranceService;
import gov.va.med.mhv.getcare.validator.HealthInsuranceValidator;

@Component
public class HealthInsuranceServiceImpl implements HealthInsuranceService {
	
	private static Logger log = LogManager.getLogger(HealthInsuranceServiceImpl.class);
	
	@Autowired
	private HealthInsuranceRepository insuranceRepository;
	
	@Autowired
	private HealthInsuranceValidator validator;


	@Override
	public ResponseUtil save(HealthInsuranceDTO healthInsuranceDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.insuranceValidations(response, healthInsuranceDTO);
		if(response.getValidationErrors().size() == 0){
			HealthInsurance insurance = HealthInsuranceConverter.convertHealthInsuranceDTO(healthInsuranceDTO);
			insuranceRepository.save(insurance);
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Health Insurance record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		insuranceRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	
	@Override
	public HealthInsuranceDTO findByPrimaryKey(Long id) {
		HealthInsuranceDTO healthInsuranceDTO = null;
		HealthInsurance insurance = insuranceRepository.findOne(id);
		if (insurance != null) {
			healthInsuranceDTO = HealthInsuranceConverter.convertHealthInsuranceDomain(insurance);
		} else {
			log.debug("Health Insurance not found for id:");
			log.debug(id);
		}

		return healthInsuranceDTO;
	}

	@Override
	public List<HealthInsuranceDTO> findInsurancesForUser(Long userprofileid) {
		List<HealthInsuranceDTO> dtos = null;
		List<HealthInsurance> insurances = insuranceRepository.findInsurancesForUser(userprofileid);
		if (insurances != null) {
			dtos = HealthInsuranceConverter.convertHealthInsurances(insurances);
		} else {
			log.debug("Health Insurance records not found for userprofileid:");
			log.debug(userprofileid);
		}

		return dtos;
	}

	@Override
	public List<HealthInsuranceDTO> findDashBoardInsurancesForUser(Long userprofileid) {
		List<HealthInsuranceDTO> dtos = null;
		Pageable topFive = new  PageRequest(0,5);
		List<HealthInsurance> insurances=insuranceRepository.findDashBoardInsurancesForUser(userprofileid,topFive);
		if(insurances != null){
			dtos = HealthInsuranceConverter.convertHealthInsurances(insurances);
		}else{
			log.debug("Dash board Health Insurance records not found for userprofileid:");
			log.debug(userprofileid);
		}

		return dtos;
	}
	
}
