package gov.va.med.mhv.getcare.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.converter.HealthCareProviderConverter;
import gov.va.med.mhv.getcare.model.HealthCareProvider;
import gov.va.med.mhv.getcare.repository.HealthCareProviderRepository;
import gov.va.med.mhv.getcare.service.HealthCareProviderService;
import gov.va.med.mhv.getcare.validator.HealthCareProviderValidator;

@Component
public class HealthCareProviderServiceImpl implements HealthCareProviderService {

	private static Logger log = LogManager.getLogger(HealthCareProviderServiceImpl.class);

	@Autowired
	private HealthCareProviderRepository healthCareProviderRepository;

	@Autowired
	private HealthCareProviderConverter converter;

	@Autowired
	private HealthCareProviderValidator validator;

	@Override
	public ResponseUtil saveHealthCareProvider(HealthCareProviderDTO healthCareProviderDto) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.providerValidations(response, healthCareProviderDto);
		if(response.getValidationErrors().size() == 0){
			HealthCareProvider provider = HealthCareProviderConverter.convertHealthCareProviderDTO(healthCareProviderDto);
			healthCareProviderRepository.save(provider);
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Health Care provider record save:");
		}
		return response;
	}


	@Override
	public ResponseUtil delete(Long id) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		try {
		healthCareProviderRepository.delete(id);
		}catch (Exception e) {
			log.error("Exception Caught deleting HealthCare Provider <<<" + id + ">>> ", e);
			response.setFailure(true);
			throw new MHVException("Exception Caught deleting HealthCare Provider", e);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public HealthCareProviderDTO findByPrimaryKey(Long id) throws MHVException {
		HealthCareProvider provider = healthCareProviderRepository.findOne(id);
		HealthCareProviderDTO providerDTO = null;
		if(provider != null){
			providerDTO = HealthCareProviderConverter.convertHealthCareProviderDomain(provider);
		} else {
			log.debug("Health Care Provider not found for id:");
			log.debug(id);
		}
		
		return providerDTO;
	}

	@Override
	public List<HealthCareProviderDTO> findProvidersForUser(Long userprofileid) throws MHVException {
		List<HealthCareProvider> providers = healthCareProviderRepository.findProvidersForUser(userprofileid);
		List<HealthCareProviderDTO> dtos = null;
		if (providers != null) {
			dtos = HealthCareProviderConverter.convertHealthCareProviders(providers);
		} else {
			log.debug("Provider Records not found for userprofileid:");
			log.debug(userprofileid);
		}

		return dtos;
	}

	@Override
	public List<HealthCareProviderDTO> findDashBoardProvidersForUser(Long userprofileid) throws MHVException {
		Pageable topFive = new PageRequest(0, 5);
		List<HealthCareProvider> providers = healthCareProviderRepository.findDashboardProvidersForUser(userprofileid,
				topFive);
		List<HealthCareProviderDTO> dtos = null;
		if (providers != null) {
			dtos = HealthCareProviderConverter.convertHealthCareProviders(providers);
		} else {
			log.debug(" Dashboard Provider Records not found for userprofileid:");
			log.debug(userprofileid);
		}

		return dtos;
	}
}
