package gov.va.med.mhv.getcare.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.getcare.common.dto.AppointmentDTO;
import gov.va.med.mhv.getcare.converter.AppointmentConverter;
import gov.va.med.mhv.getcare.model.Appointment;
import gov.va.med.mhv.getcare.repository.AppointmentRepository;
import gov.va.med.mhv.getcare.service.AppointmentService;

@Component
public class AppointmentServiceImpl  implements AppointmentService {
	
	private static Logger log = LogManager.getLogger(AppointmentServiceImpl.class);
	
	@Autowired
	private AppointmentRepository appointmentRepository;
	
	
	@Override
	public List<AppointmentDTO> findAppointmentsForPatient(Long patientid) throws MHVException {
		List<AppointmentDTO> dtos = null;
		List<Appointment> appointments = appointmentRepository.getAppointmentsForPatient(patientid);
		if (appointments != null) {
			dtos = AppointmentConverter.convertAppoinmentRecords(appointments);
		} else {
			log.debug("Allergy Records not found for PatientId:");
			log.debug(patientid);
		}
		
		return dtos;
	}
}
