package gov.va.med.mhv.getcare.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.converter.FacilityInfoConveter;
import gov.va.med.mhv.getcare.common.dto.WellnessReminderDTO;
import gov.va.med.mhv.getcare.model.WellnessReminder;
import gov.va.med.mhv.getcare.util.WellnessReminderDecorator;

@Component
public class WellnessReminderConverter implements Converter<WellnessReminder, WellnessReminderDTO> {

	@Autowired
	private FacilityInfoConveter facilityInfoConveter;
	
	@Override
	public WellnessReminderDTO convert(WellnessReminder source) {
		WellnessReminderDTO target = new WellnessReminderDTO();
		
		target.setId(source.getId());
		target.setStationNumber(source.getStationNumber());
		target.setExtactDate(source.getExtactDate());
		target.setDueDatePrecise(source.getDueDatePrecise());
		target.setDueDateImrecise(source.getDueDateImrecise());
		target.setDateLastDonePrecise(source.getDateLastDonePrecise());
		target.setDateLastDoneImprecise(source.getDateLastDoneImprecise());
		target.setWellnessStatus(source.getWellnessStatus());
		target.setSubject(source.getSubject());
		target.setPatientId(source.getPatientId());
		target.setFacilityInfoId(source.getFacilityInfoId());
		
		if (null != source.getFacilityInfo()) {
			target.setFacilityInfo(facilityInfoConveter.convertDomainFacilityInfo(source.getFacilityInfo()));
		}
		
		target.setPhrFacilityControlId(source.getPhrFacilityControlId());
		
		if (null != source.getFullSummary()) {
			target.setFullSummary(WellnessReminderDecorator.getFullSummary(source.getFullSummary()));
		}
		
		return target;
	}
	
	public WellnessReminder convert(WellnessReminderDTO source) {
		WellnessReminder target = new WellnessReminder();
		
		target.setId(source.getId());
		target.setOplock(1);
		target.setStationNumber(source.getStationNumber());
		target.setExtactDate(source.getExtactDate());
		target.setDueDatePrecise(source.getDueDatePrecise());
		target.setDueDateImrecise(source.getDueDateImrecise());
		target.setDateLastDonePrecise(source.getDateLastDonePrecise());
		target.setDateLastDoneImprecise(source.getDateLastDoneImprecise());
		target.setWellnessStatus(source.getWellnessStatus());
		target.setSubject(source.getSubject());
		target.setPatientId(source.getPatientId());
		target.setFacilityInfoId(source.getFacilityInfoId());
		target.setPhrFacilityControlId(source.getPhrFacilityControlId());
		//target.setFullSummary(source.getFullSummary());
		
		return target;
	}
}
