package gov.va.med.mhv.getcare.repository;

import gov.va.med.mhv.getcare.model.WellnessReminder;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface WellnessReminderRepository extends JpaRepository<WellnessReminder, Long>{
	
	 @Query("select wr from WellnessReminder wr " +
			 "where (wr.patientId = :patientId) " +
			 		"and wr.wellnessStatus in ('RESOLVED', 'DONE') " +
			 		"and wr.phrFacilityControlId is not null " +
					"and wr.facilityInfoId in ( " +
					     "select wp.facilityInfoId from WellnessPreference wp where wp.patientId = :patientId) " +
					"order by wr.dueDateImrecise asc, wr.facilityInfoId asc, wr.subject desc")
	 List<WellnessReminder> getResolvedStatusWellnessRemindersByPatientId(@Param ("patientId") Long patientId);

	 @Query("select wr from WellnessReminder wr " +
			 "where (wr.patientId = :patientId) " +
			 		"and wr.wellnessStatus not in ('RESOLVED', 'DONE') " +
					"and wr.phrFacilityControlId is not null " +
					"and wr.facilityInfoId in ( " +
					     "select wp.facilityInfoId from WellnessPreference wp where wp.patientId = :patientId) " +
	 				"order by wr.dueDateImrecise asc, wr.facilityInfo.name asc, wr.subject desc")
	 List<WellnessReminder> getUnresolvedStatusWellnessRemindersByPatientId(@Param ("patientId") Long patientId);

}
