package gov.va.med.mhv.getcare.repository;

import java.util.List;

import javax.transaction.Transactional;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.getcare.model.WellnessPreference;

@Repository
public interface WellnessPreferenceRepository extends JpaRepository<WellnessPreference, Long>{
	
	 @Query("select wp from WellnessPreference wp " +
			 "where wp.patientId = :patientId " +
			 "and wp.phrFacilityControlId is not null")
	 List<WellnessPreference> getWellnessPreferencesByPatientId(@Param ("patientId") Long patientId);
	 
	 @Modifying
	 @Transactional
	 @Query("delete from WellnessPreference wp where wp.patientId = :patientId")
	 void deleteWellnessPreferencesByPatientId(@Param ("patientId") Long patientId);
}
