package gov.va.med.mhv.getcare.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.FacilityInfo;

@Entity
@Table(name = "PHR_WELLNESS_PREFERENCE")
public class WellnessPreference implements Serializable {

	private static final long serialVersionUID = -1152801194753451823L;

	@Id
	@Column(name = "PHR_WELLNESS_PREFERENCE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "FACILITY_INFO_ID", insertable = false, updatable = false)
	private Long facilityInfoId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_ID")
	private FacilityInfo facilityInfo;

	@Column(name = "PHR_FACILITY_CONTROL_ID")
	private Long phrFacilityControlId;

	@Column(name = "PATIENT_ID")
	private Long patientId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public FacilityInfo getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfo facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	@Override
	public boolean equals(Object obj) {
		boolean flag = false;

		// check for self-comparison
		if (this == obj) {
			flag = true;
		} else {
			if (!(obj instanceof WellnessPreference)) {
				flag = false;
			} else {
				WellnessPreference wr = (WellnessPreference) obj;
				if (this.id.compareTo(wr.getId()) == 0) {
					flag = true;
				} else {
					flag = false;
				}
			}
		}
		return flag;
	}
	
	@Override
	public int hashCode() {
		return this.id.hashCode();
	}
}
