package gov.va.med.mhv.getcare.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

/**
 * This class is the decorator for the wellness reminder Summary and details.
 */
public class WellnessReminderDecorator implements Serializable {

	private static final long serialVersionUID = -7069372160082275849L;
	protected static final String BLANK = StringEscapeUtils.escapeHtml("");
	private static final String DUE_NOW = "DUE NOW";
	private static final String PAST_DUE = "PAST DUE";
	private static final String DATE_FORMAT_STRING = "MM/dd/yyyy";

	// private final WellnessReminderDTO wellnessReminder;

	public static String escapedValueOrBlank(String value) {
		return StringUtils.isBlank(value) ? BLANK : escapedValue(value);
	}

	public static String escapedValue(String value) {
		return StringEscapeUtils.escapeHtml(value);
	}

	/*
	 * public Long getId() { return wellnessReminder.getId(); }
	 */

	/*
	 * Contructor for the WellnessReminderDecorator class
	 *
	 * @param wellnessReminder The wellnessReminder object to decorate
	 */
	/*
	 * @SuppressWarnings("unchecked") public
	 * WellnessReminderDecorator(WellnessReminderDTO wellnessReminder) {
	 * this.wellnessReminder = wellnessReminder; }
	 */

	/*
	 * This method retrieves the Imprecise due date and formats it into a
	 * readable date/time string for display.
	 *
	 * @return a String value containing the formatted due Date
	 */
	/*
	 * public String getDueDate() { return process(); }
	 */

	public static String process(String dateImprecise) {
		ImpreciseDateComposite dueDate = new ImpreciseDateComposite(dateImprecise);

		if (dueDate == null || ((dueDate.getImpreciseValue() == null && dueDate.getValue() == null)
				|| ("".equals(dueDate.getImpreciseValue()) && ("".equals(dueDate.getValue()))))) {
			return DUE_NOW;
		} else {
			String value = extractValue(dueDate);
			try {
				Date obj = new SimpleDateFormat(DATE_FORMAT_STRING).parse(value);
				Date today = new Date();
				if (today.after(obj)) {
					return PAST_DUE;
				} else {
					return value;
				}
			} catch (ParseException pe) {
				return value;
			}
		}
	}

	/*
	 * This symbol shows up in the Wellness Reminders summary page only if the
	 * value of due date is PAST DUE or DUE NOW
	 */
	public static boolean getShowSymbol(String dateImrecise) {

		String dueDateValue = process(dateImrecise);
		if (dueDateValue.equals(PAST_DUE) || dueDateValue.equals(DUE_NOW)) {
			return true;
		}

		return false;
	}

	/*
	 * This method retrieves the Imprecise date last done and formats it into a
	 * readable date/time string for display.
	 *
	 * @return a String value containing the formatted date last done
	 */
	public static String getDateLastDone(String dateImprecise) {
		ImpreciseDateComposite dateLastDone = new ImpreciseDateComposite(dateImprecise);

		if (dateLastDone == null || ((dateLastDone.getImpreciseValue() == null && dateLastDone.getValue() == null)
				|| ("".equals(dateLastDone.getImpreciseValue()) && dateLastDone.getValue() == null))) {
			return "";
		} else {
			return extractValue(dateLastDone);
		}
	}

	/*
	 * This method returns the full summary of the Wellness Reminder
	 *
	 * @return a String contaning the full summary.
	 */

	public static String getFullSummary(String fullSummary) {
		String protocol_http = "http://";
		String protocol_https = "https://";

		if (fullSummary != null) {
			String firstLoop = convert(fullSummary, protocol_http);
			String finalSummary = convert(firstLoop, protocol_https);
			return encode(finalSummary);
		} else {
			return "";
		}
	}

	private static String convert(String fullSummary, String protocol) {
		StringBuffer strBuffer = new StringBuffer();

		while (true) {
			if (fullSummary.indexOf(protocol) != -1) {
				String temp = fullSummary.substring(0, fullSummary.indexOf(protocol));

				if (temp == null || "".equals(temp))
					break;
				strBuffer.append(temp);
				String tempFullSummary = fullSummary.substring(fullSummary.indexOf(protocol), fullSummary.length());

				if (tempFullSummary.indexOf("\n") != -1) {
					temp = tempFullSummary.substring(0, tempFullSummary.indexOf("\n") + 1);
					strBuffer.append(buildAnchorTag(temp));
					fullSummary = tempFullSummary.substring(tempFullSummary.indexOf("\n"), tempFullSummary.length());
				} else {
					temp = tempFullSummary;
					strBuffer.append(buildAnchorTag(temp));
					fullSummary = "";
				}
			} else {
				strBuffer.append(fullSummary);
				break;
			}
		}
		return strBuffer.toString();
	}

	private static String buildAnchorTag(String temp) {
		if (temp.endsWith("\n")) {
			temp = temp.substring(0, temp.length() - 1);
		}
		return "<a href='" + temp + "' target='_blank'>" + temp + "</a>";
	}

	public static String encode(String raw) {
		if (raw == null)
			return "";
		String result = raw.replaceAll("\n", "<br/>");
		return result;
	}

	/*
	 * This method returns the name of the status of the Wellness Reminder
	 *
	 * @return a String contaning the status.
	 */
	/*
	 * public String getWellnessStatus() { return
	 * escapedValue(wellnessReminder.getWellnessStatus()); }
	 * 
	 * 
	 * This method returns the name of the subject of the Wellness Reminder
	 *
	 * @return a String contaning the subject.
	 * 
	 * public String getSubject() { return
	 * escapedValue(wellnessReminder.getSubject()); }
	 * 
	 * 
	 * 
	 * This method returns the name of the location of the Wellness Reminder
	 *
	 * @return a String contaning the location.
	 * 
	 * public String getLocation() { return
	 * escapedValue(wellnessReminder.getFacilityInfo().getName()); }
	 */

	/**
	 * This method attempts to get the value and tries to extract the value
	 * depending on the imprecise date (which could be a string) or precise
	 * value (which could be a timestamp).
	 * 
	 * @param dateComposite
	 * @return
	 */

	public static String extractValue(ImpreciseDateComposite dateComposite) {
		if (dateComposite == null) {
			return null;
		}
		String impreciseValue = dateComposite.getImpreciseValue();
		if (impreciseValue != null && !"".equals(impreciseValue)) {
			return impreciseValue;
		}
		return formatDate(new Date(dateComposite.getValue().getTime()));
	}

	private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>() {
		@Override
		protected synchronized DateFormat initialValue() {
			return new SimpleDateFormat(DATE_FORMAT_STRING);
		}
	};

	public static String formatDate(Date value) {
		return (value != null) ? getDateFormat().format(value) : null;
	}

	public static DateFormat getDateFormat() {
		return dateFormat.get();
	}
}
