package gov.va.med.mhv.getcare.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.WellnessPreferenceDTO;
import gov.va.med.mhv.getcare.common.dto.WellnessReminderDTO;

@Path("/")
@Service("wellnessReminderService")
public interface WellnessReminderService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/reminder/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/wellnessReminder/{id}")
	public WellnessReminderDTO getWellnessReminderById(@PathParam("id") Long id) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/resolvedReminders/{patientId}")
	public List<WellnessReminderDTO> getResolvedStatusWellnessReminders(@PathParam("patientId") Long patientId) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/unresolvedReminders/{patientId}")
	public List<WellnessReminderDTO> getUnresolvedStatusWellnessReminders(@PathParam("patientId") Long patientId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/reminderPreferences/{patientId}")
	public List<WellnessPreferenceDTO> getWellnessPreferencesByPatientId(@PathParam("patientId") Long patientId) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deletePreferences/{patientId}")
	public ResponseUtil deleteWellnessPreferencesByPatientId(@PathParam("patientId") Long patientId) throws MHVException;
	
	@POST
	@Path("/reminderPreferences")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public ResponseUtil saveWellnessPreference(WellnessPreferenceDTO WellnessPreferenceDto) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/phrFacilityControl/{facilityId}")
	public Long getPhrFacilityControlByFacilityId(@PathParam("facilityId") Long facilityId) throws MHVException;
}