package gov.va.med.mhv.getcare.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;

public interface TreatmentFacilityService {
	
	@POST
	@Path("/treatmentFacility")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public ResponseUtil save(TreatmentFacilityDTO treatmentFacilityDTO) throws MHVException;

	@DELETE
	@Path("/deleteTreatmentFacility/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public ResponseUtil delete(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/treatmentFacilityById/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public TreatmentFacilityDTO findByPrimaryKey(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/treatmentFacility/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<TreatmentFacilityDTO> findFacilitiesForUser(@PathParam("userid") Long userid) throws MHVException;

	@GET
	@Path("/dashboardTreatmentFacility/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<TreatmentFacilityDTO> findDashBoardFacilitiesForUser(@PathParam("userid") Long userid) throws MHVException;
}
