package gov.va.med.mhv.getcare.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;

@Path("/")
@Service("healthcareproviderService")
public interface HealthCareProviderService {

	@POST
	@Path("/healthCareProvider")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public ResponseUtil saveHealthCareProvider(HealthCareProviderDTO healthCareProviderDTO) throws MHVException;

	@DELETE
	@Path("/deleteHealthProvider/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public ResponseUtil delete(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/healthProvdierById/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public HealthCareProviderDTO findByPrimaryKey(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/healthCareProvider/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<HealthCareProviderDTO> findProvidersForUser(@PathParam("userid") Long userid) throws MHVException;

	@GET
	@Path("/dashboardHealthCareProvider/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<HealthCareProviderDTO> findDashBoardProvidersForUser(@PathParam("userid") Long userid)
			throws MHVException;
}