package gov.va.med.mhv.getcare.common.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.getcare.util.ImpreciseDateComposite;
import gov.va.med.mhv.getcare.util.WellnessReminderDecorator;

public class WellnessReminderDTO implements Serializable {

	private static final long serialVersionUID = 7478795232721991751L;

	private Long id;
	private String stationNumber;
	private Date extactDate;
	private String dueDatePrecise;
	private String dueDateImrecise;
	private String dateLastDonePrecise;
	private String dateLastDoneImprecise;
	private String wellnessStatus;
	private String subject;
	private Long patientId;
	private Long facilityInfoId;
	private FacilityInfoDTO facilityInfo;
	private Long phrFacilityControlId;
	private String fullSummary;

	@JsonIgnore
	private ImpreciseDateComposite dueDateComposite;
	@JsonIgnore
	private ImpreciseDateComposite dateLastDoneComposite;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public Date getExtactDate() {
		return extactDate;
	}

	public void setExtactDate(Date extactDate) {
		this.extactDate = extactDate;
	}

	public String getDueDatePrecise() {
		return dueDatePrecise;
	}

	public void setDueDatePrecise(String dueDatePrecise) {
		this.dueDatePrecise = dueDatePrecise;
	}

	public String getDueDateImrecise() {
		return dueDateImrecise;
	}

	public void setDueDateImrecise(String dueDateImrecise) {
		this.dueDateImrecise = dueDateImrecise;
	}

	public String getDateLastDonePrecise() {
		return dateLastDonePrecise;
	}

	public void setDateLastDonePrecise(String dateLastDonePrecise) {
		this.dateLastDonePrecise = dateLastDonePrecise;
	}

	public String getDateLastDoneImprecise() {
		return dateLastDoneImprecise;
	}

	public void setDateLastDoneImprecise(String dateLastDoneImprecise) {
		this.dateLastDoneImprecise = dateLastDoneImprecise;
	}

	public String getWellnessStatus() {
		return wellnessStatus;
	}

	public void setWellnessStatus(String wellnessStatus) {
		this.wellnessStatus = wellnessStatus;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public FacilityInfoDTO getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfoDTO facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

	public String getFullSummary() {
		return fullSummary;
	}

	public void setFullSummary(String fullSummary) {
		this.fullSummary = fullSummary;
	}

	@JsonIgnore
	public String getDueDate() {
		return WellnessReminderDecorator.process(this.dueDateImrecise);
	}

	@JsonIgnore
	public boolean getShowSymbol() {
		return WellnessReminderDecorator.getShowSymbol(this.dueDateImrecise);
	}

	@JsonIgnore
	public String getDateLastDone() {
		return WellnessReminderDecorator.getDateLastDone(this.dateLastDoneImprecise);
	}

	@JsonIgnore
	public String getLocation() {
		return (null != facilityInfo) ? facilityInfo.getName() : "";
	}
}
