package gov.va.med.mhv.getcare.common.dto;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.getcare.enums.ProviderTypeEnumeration;

public class HealthCareProviderDTO implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String regex ="[-()\\sx]";
	
	private Long healthCareProviderId;
	private String firstName;
	private String lastName;
	private String providerType;// Primary, Specialist, Dentist, Eye, Other
								// Clinician
	private String otherClinician;
	private String workPhone;
	private String workPhoneExt;
	private String emailAddress;
	private String comments;
	private Long userProfileId;

	public HealthCareProviderDTO() {
	}
	
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getProviderType() {
		return providerType;
	}

	public void setProviderType(String providerType) {
		this.providerType = providerType;
	}

	public String getOtherClinician() {
		return otherClinician;
	}

	public void setOtherClinician(String otherClinician) {
		this.otherClinician = otherClinician;
	}

	
	public Long getHealthCareProviderId() {
		return healthCareProviderId;
	}

	public void setHealthCareProviderId(Long healthCareProviderId) {
		this.healthCareProviderId = healthCareProviderId;
	}

	public String getWorkPhone() {
		return workPhone;
	}

	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}

	public String getWorkPhoneExt() {
		return workPhoneExt;
	}

	public void setWorkPhoneExt(String workPhoneExt) {
		this.workPhoneExt = workPhoneExt;
	}

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	@JsonIgnore
	public ProviderTypeEnumeration[] getProviderTypes() {
		return ProviderTypeEnumeration.values();
	}

	@Override
	@JsonIgnore
	public String toString() {
		return "HealthCareProviderDTO [healthCareProviderId=" + healthCareProviderId + ", firstName="
				+ firstName + ", lastName=" + lastName + ", providerType=" + providerType + ", otherClinician=" + otherClinician
				+ ", workPhone=" + workPhone + ", workPhoneExt=" + workPhoneExt + ", emailAddress=" + emailAddress + ", comments="
				+ comments + ", userProfileId=" + userProfileId + "]";
	}
	
	@JsonIgnore
	public String getDisplayProviderType(){
    	String providerType=null;
    	if(getProviderType() != null){
    		providerType=ProviderTypeEnumeration.valueOf(getProviderType()).getDescription();
    	}
    	return providerType;
    }
	
	@JsonIgnore
	public String getProviderName(){
		StringBuffer sb= new StringBuffer();
		return sb.append( getFirstName() ).append(" ").append(getLastName()).toString();
    }
	
	@JsonIgnore
	public String getPhone(){
		StringBuffer sb = new StringBuffer();
		if(getWorkPhone() != null){
		   sb.append(getWorkPhone());
		}
		if(getWorkPhoneExt() != null){
		   sb.append(" ");	
		   sb.append("x");
		   sb.append(getWorkPhoneExt());
		}
		return sb.toString();
	}

	@JsonIgnore
	public String getPhoneNumbersOnly(){
		String inputString=getPhone();
		String outputString=null;
		if(inputString != null){
			outputString =inputString.replaceAll(regex, "");
		}
		return outputString;
	}
}