package com.liferay.portlet.login;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.CookieNotSupportedException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PortletKeys;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebKeys;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.login.action.LoginAction;



public class CustomLoginAction extends LoginAction{
	
	private static Log LOGGER = LogFactoryUtil.getLog(CustomLoginAction.class);
	
	private static final String SAVE_LAST_PATH_PARAM = "saveLastPath";
	private static final String LOGIN_PARAM_PARAM = "login";
	
	protected void postProcessAuthFailure(
			ActionRequest actionRequest, ActionResponse actionResponse)
		throws Exception {

		Layout layout = (Layout)actionRequest.getAttribute(WebKeys.LAYOUT);

		PortletURL portletURL = new PortletURLImpl(
			actionRequest, PortletKeys.LOGIN, layout.getPlid(),
			PortletRequest.RENDER_PHASE);
		
		String login = actionRequest.getParameter(LOGIN_PARAM_PARAM);
		
		if(LOGGER.isDebugEnabled()) {
			LOGGER.debug(String.format("Login failed. Login ID is: %s", login));
		}

		portletURL.setParameter(LOGIN_PARAM_PARAM, login);
		portletURL.setParameter(SAVE_LAST_PATH_PARAM, Boolean.FALSE.toString());
		SessionMessages.add(actionRequest, PortalUtil.getPortletId(actionRequest) +	SessionMessages.KEY_SUFFIX_HIDE_DEFAULT_ERROR_MESSAGE);
		actionResponse.sendRedirect(portletURL.toString());
	}
	
	
	@Override
	public void processAction(
			ActionMapping actionMapping, ActionForm actionForm,
			PortletConfig portletConfig, ActionRequest actionRequest,
			ActionResponse actionResponse)
		throws Exception {

		ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute(
			WebKeys.THEME_DISPLAY);

		if (PropsValues.AUTH_LOGIN_DISABLED) {
			actionResponse.sendRedirect(
				themeDisplay.getPathMain() +
					PropsValues.AUTH_LOGIN_DISABLED_PATH);

			return;
		}

		/*if (actionRequest.getRemoteUser() != null) {
			actionResponse.sendRedirect(themeDisplay.getPathMain());

			return;
		}*/

		try {
			login(themeDisplay, actionRequest, actionResponse);

			boolean doActionAfterLogin = ParamUtil.getBoolean(
				actionRequest, "doActionAfterLogin");

			if (doActionAfterLogin) {
				setForward(actionRequest, "portlet.login.login_redirect");
			}
		}
		catch (Exception e) {
			
			if (e instanceof AuthException) {
				Throwable cause = e.getCause();
				
				if(null != cause && null !=cause.getClass() && null !=cause.getClass().getName() && cause.getClass().getName().endsWith("UserDeactivatedException")){
					SessionMessages.add(actionRequest, "UserDeactivatedException");
					SessionMessages.add(PortalUtil.getHttpServletRequest(actionRequest), "UserDeactivatedException");
					LOGGER.debug("User Deactivated message added to Session Messages::");
					LOGGER.error(e.getMessage());
				}else if(null != cause && null !=cause.getClass() && null !=cause.getClass().getName() && cause.getClass().getName().endsWith("SystemDownException")){
					SessionMessages.add(actionRequest, "SystemDownException");
					SessionMessages.add(PortalUtil.getHttpServletRequest(actionRequest), "SystemDownException");
					LOGGER.debug("System Down message added to Session Messages::");
					LOGGER.error(e.getMessage());
				}else if (cause instanceof PasswordExpiredException ||
					cause instanceof UserLockoutException  ) {

					SessionErrors.add(actionRequest, cause.getClass());
				}
				else {
					if (LOGGER.isInfoEnabled()) {
						LOGGER.info("Authentication failed");
					}

					SessionErrors.add(actionRequest, e.getClass());
				}
			}
			else if (e instanceof CompanyMaxUsersException ||
					 e instanceof CookieNotSupportedException ||
					 e instanceof NoSuchUserException ||
					 e instanceof PasswordExpiredException ||
					 e instanceof UserEmailAddressException ||
					 e instanceof UserIdException ||
					 e instanceof UserLockoutException ||
					 e instanceof UserPasswordException ||
					 e instanceof UserScreenNameException) {

				SessionErrors.add(actionRequest, e.getClass());
			}
			else {
				LOGGER.error(e, e);

				PortalUtil.sendError(e, actionRequest, actionResponse);

				return;
			}

			postProcessAuthFailure(actionRequest, actionResponse);
		}
	}


}
