package gov.va.mhv.util.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import org.jdom2.Content;
import org.jdom2.Namespace;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

/** Queried an XML document via XPath expressions.
 */
public abstract class XPathSelectorAbstract
{
	protected final Logger logger = Logger.getLogger(getClass().getPackage().getName());

	public Set<Namespace> namespaces;
	public Map<String,Object> vars;

	public static Set<Namespace> EMPTY_NAMESPACE = new HashSet<Namespace>();
	public static Map<String,Object> EMPTY_VARS = new HashMap<String,Object>();

	public XPathSelectorAbstract() {
		this.namespaces= EMPTY_NAMESPACE;
		this.vars = EMPTY_VARS;
	}

	public XPathSelectorAbstract(Set<Namespace> namespaces) {
		this();
		// make an internal copy because defineAliasPrefix() might modify it
		this.namespaces = new HashSet<Namespace>(namespaces);
	}

	//--------------------------------------------------------------------------------

	/**
	 * Create an XPathExpression for the given expr string and optional filter.
	 * @param expr
	 * @param filter
	 * @return the XPathExpression
	 */
	protected <T extends Content> XPathExpression<T> compileSelector(String expr, Filter<T> filter)
	{
		if (filter == null) {
			filter = (Filter<T>) Filters.content();
		}
//		Map<String,Object> varz = null;
//		if (expr.indexOf('$') != -1) {
//			varz = new HashMap<>(vars);
//			for (String varName : varz.keySet()) {
//				System.out.println("~~~~~ INIT " + varName);
//				varz.put(varName, null);
//			}
//		}
		return XPathFactory.instance().compile(expr, filter, this.vars, this.namespaces);
	}

	protected static String descExpr(XPathExpression xe)
	{
		String s = xe.getFilter().toString();
		int i = s.lastIndexOf('.');
		String filterType = s.substring(i+1, s.length() - 1);

		return "(" + filterType + ") '" + xe.getExpression() + "'";
	}

	// ================================================================================

	/**
	 * Instantiate an XPathMapSelector using the same doc/namespaces/vars
	 * @param selectMap
	 * @return XPathMapSelector object
	 */
	public XPathMapSelector createMapSelector(Map<String,XPathSelectExpr> selectMap)
	{
		XPathMapSelector xms = new XPathMapSelector(namespaces, selectMap);
		xms.vars = new HashMap<String,Object>(vars);
		return xms;
	}
}
