package gov.va.mhv.util.xml;

import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filter;
import org.jdom2.xpath.XPathExpression;

/** Queried an XML document via XPath expressions.
 */
public class XPathSelector extends XPathSelectorAbstract
{
	protected final Logger logger = Logger.getLogger(getClass().getPackage().getName());

	public XPathSelector() {
		super();
	}

	public XPathSelector(Set<Namespace> namespaces) {
		super(namespaces);
	}

	//--------------------------------------------------------------------------------

	/**
	 * Find all matching Elements.
	 * @param expr
	 * @return the list of matching elements, if any
	 */
	public <T extends Content> List<T> selectAll(Object doc, String expr) {
		return selectAll(doc, expr, null);
	}
	public <T extends Content> List<T> selectAll(Element e, String expr) {
		return selectAll(e, expr, null);
	}

	/**
	 * Find all matching Elements.
	 * @param expr
	 * @param filter
	 * @return the list of matching elements, if any
	 */
	public <T extends Content> List<T> selectAll(Object doc, String expr, Filter<T> filter) {
		List<T> result = null;
		XPathExpression<T> xe = compileSelector(expr, filter);
		result = xe.evaluate(doc);
		logger.fine("For " + descExpr(xe) + ", found " + result.size() + " items");
		return result;
	}
	public <T extends Content> List<T> selectAll(Element e, String expr, Filter<T> filter) {
		Document doc = new Document(e.detach());
		return selectAll(doc, expr, filter);
	}

	/**
	 * Find the first matching document element.
	 * @param expr
	 * @return the element, if any
	 */
	public <T extends Content> T selectFirst(Object doc, String expr) {
		return selectFirst(doc, expr, null);
	}
	public <T extends Content> T selectFirst(Element e, String expr) {
		return selectFirst(e, expr, null);
	}

	/**
	 * Find the first matching document element.
	 * @param expr
	 * @param filter
	 * @return the element, if any
	 */
	public <T extends Content> T selectFirst(Object doc, String expr, Filter<T> filter) {
		T result = null;
		XPathExpression<T> xe = compileSelector(expr, filter);
		result = xe.evaluateFirst(doc);
		logger.fine("For " + descExpr(xe) + ", found: " + result);
		return result;
	}
	public <T extends Content> T selectFirst(Element e, String expr, Filter<T> filter) {
		Document doc = new Document(e.detach());
		return selectFirst(doc, expr, filter);
	}
}
