package gov.va.mhv.util.distributor.message;

import gov.va.mhv.util.distributor.http.HTTPAuthMethod;
import gov.va.mhv.util.distributor.http.HTTPMethod;
import gov.va.mhv.util.distributor.http.HTTPVersion;

import java.io.InputStream;
import java.util.Map;

/**
 * Class that is used to request information via HTTP distribution
 *
 */
public class HTTPRequestBean extends BaseRequest {
	
	private boolean redirect;
	private HTTPMethod httpMethod;
	private HTTPAuthMethod httpAuthMethod;
	private HTTPVersion httpVersion;
	
	/**
	 * Sets the request body
	 * @param body
	 */
	public void setBody(String body){
		this.body = body;
	}

	/**
	 * Sets the password for if credentials are required by the client
	 * @param password
	 */
	public void setPassword(char[] password) {
		this.password = password;
	}

	/**
	 * Sets a map of the properties
	 * @param map
	 */
	public void setProperties(Map<String, ?> properties) {
		this.properties = properties;
	}

	/**
	 * Sets the user name if login credentials are required by the client
	 * @param user
	 */
	public void setUsername(String user) {
		this.user = user;
	}	
	
	/**
	 * Sets the Method type of the HTTP command that should be executed
	 * @param method
	 */
	public void setHttpMethod(HTTPMethod method){
		this.httpMethod = method;
	}
	
	/**
	 * Returns the HTTP method that will be executed 
	 * @return
	 */
	public HTTPMethod getHttpMethod(){
		return httpMethod;
	}
	
	/**
	 * Sets the Authentication method of the HTTP protocol.
	 * @param authMethod
	 */
	public void setHttpAuthMethod(HTTPAuthMethod httpAuthMethod){
		this.httpAuthMethod = httpAuthMethod;
	}
	
	/**
	 * Returns the HTTP authentication protocol
	 * @return
	 */
	public HTTPAuthMethod getHttpAuthMethod(){
		return httpAuthMethod;
	}
	
	/**
	 * Sets the HTTP version.  This defaults to 1.1 and should NOT
	 * be changed unless you really need to use 1.0
	 * @param version
	 */
	public void setHttpVersion(HTTPVersion httpVersion){
		this.httpVersion = httpVersion;
	}
	
	/**
	 * Returns the HTTP version that the class will use.
	 * @return
	 */
	public HTTPVersion getHttpVersion(){
		return httpVersion;
	}
	
	/**
	 * Method enables use of input stream rather then String for the body content
	 * @param inputStream
	 */
	public void setInputStream(InputStream inputStream){
		this.inputStream = inputStream;
	}
	
	/**
	 * Sets the number of attempts before giving up on the connection
	 * @param retryAttempts
	 */
	public void setRetryAttempts(int retryAttempts){
		this.retryAttempts = retryAttempts;
	}
	
	/**
	 * Sets the amount of time in milliseconds for it to attempt the connection before giving up
	 * @param timeout
	 */
	public void setRetryTimeout(int timeout){
		this.timeout = timeout;
	}
	
	/**
	 * Sets the MIME type to be set in the HTTP headers
	 * @param mimeType
	 */
	public void setMimeType(MimeType mimeType){
		this.mimeType = mimeType;
	}
	
	/**
	 * In a redirect session does the HTTP message follow the redirect
	 * @return
	 */
	public boolean isFollowRedirect() {
		return redirect;
	}
}
