package gov.va.mhv.util.client;

import gov.va.mhv.util.distributor.Distributor;
import gov.va.mhv.util.distributor.DistributorException;
import gov.va.mhv.util.distributor.HttpClientDistributor;
import gov.va.mhv.util.distributor.http.HTTPMethod;
import gov.va.mhv.util.distributor.message.BaseResponse;
import gov.va.mhv.util.distributor.message.HTTPRequestBean;
import gov.va.mhv.util.distributor.message.HTTPResponseBean;
import gov.va.mhv.util.distributor.message.MimeType;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class that will initialize the Distributor to send a message to
 * the specified URI
 *
 */
public class SimpleSender {
	
	private static Logger logger = Logger.getLogger(SimpleSender.class.getName());
	
	/**
	 * Method that is used to send a message to an HTTP endpoint
	 * @param m
	 * @param mime
	 * @param address
	 * @param body
	 * @param httpProps
	 * @return
	 */
	public static HTTPResponseBean send(HTTPMethod m, MimeType mime, String address, String body, Map<String,String> httpProps){
		
		logger.info("Service Info request from: "+address);
		
		HTTPRequestBean request = new HTTPRequestBean();
		
		request.setHttpMethod(m);
		request.setUri(address);
		request.setBody(body);
		request.setMimeType(mime);
		request.setTimeout(10000);
		request.setProperties(httpProps);
		
		try {
			HttpClientDistributor d = new HttpClientDistributor(request);
			return d.distribute();
			
		} catch (DistributorException e) {
			logger.log(Level.SEVERE,"Error Sending Request Message", e);
		}
		return null;
	}
	
	/**
	 * Command line runnable class to send HTTP messages
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		String inputFile;
		String targetURL;
		String appName;
		
		try {
			inputFile = args[0];
			targetURL = args[1];
			if (args.length>2)
				appName = args[2];
			else
				appName= "";
		} catch (Exception e) {
			usage();
			return;
		}
		
		File f = new File(inputFile);
		System.out.println("Using file:\t" + f.getAbsolutePath());
		System.out.println("Sending to:\t" + targetURL);
		
        InputStream r = new FileInputStream(new File(inputFile));
        
        Map<String, String> httpProps = new HashMap<String, String>();
        httpProps.put("SOAPAction", appName);
        
		Distributor d = null;
        try {
        	HTTPRequestBean request = new HTTPRequestBean();
        	request.setUri(targetURL);
        	request.setProperties(httpProps);
        	request.setInputStream(r);
            d = new HttpClientDistributor(request);
            BaseResponse response = d.distribute();
            
            System.out.println("Successfully sent message, response from server: "+response.getStatusCode()+"\n" + response.getResponseBody());
        } catch(DistributorException e) {
        	System.out.println("Unable to send message to server: " + e.getMessage());
        	e.printStackTrace();
        }
	}
    
	private static void usage() {
		System.out.println("Usage: SimpleSender [messageFile] [serviceURL] [Optional: SOAPAction]");
	}
}
