package gov.va.mhv.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseOpenSearchImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.ThemeDisplay;

import gov.va.mhv.util.client.SimpleSender;
import gov.va.mhv.util.distributor.http.HTTPMethod;
import gov.va.mhv.util.distributor.message.HTTPResponseBean;
import gov.va.mhv.util.distributor.message.MimeType;
import gov.va.mhv.util.xml.XPathSelector;
import gov.va.mhv.util.xml.XmlHelper;

import java.util.*;

import javax.servlet.http.HttpServletRequest;

import org.jdom2.Content;

/**
 * This is the base class used to integrate the VA Enterprise Search with Lifeary.  
 * This portlet project needs to be deployed to liferay as a portlet, and the Search funcionality will 
 * automatically call it when searches are conducted.
 * 
 * @author Raphael Silvestro
 *
 */
public class EnterpriseSearch extends BaseOpenSearchImpl {

	@Override
	public boolean isEnabled() {
		return true;
	}

	@Override
	public String search(
			HttpServletRequest request, long groupId, long userId,
			String keywords, int startPage, int itemsPerPage, String format)
					throws SearchException {
		try {
			ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute(
					WebKeys.THEME_DISPLAY);
			SearchContext searchContext = SearchContextFactory.getInstance(
					request);
			searchContext.setAttribute("paginationType", "more");
			if (groupId == 0) {
				searchContext.setGroupIds(null);
			}
			else {
				searchContext.setGroupIds(new long[] {groupId});
			}
			int end = startPage * itemsPerPage;
			searchContext.setEnd(end);
			Layout layout = themeDisplay.getLayout();
			Group layoutGroup = layout.getGroup();
			if (!layoutGroup.isStagingGroup() &&
					!layoutGroup.isControlPanel()) {
				searchContext.setIncludeStagingGroups(false);
			}
			searchContext.setKeywords(keywords);
			searchContext.setScopeStrict(false);
			int start = (startPage * itemsPerPage) - itemsPerPage;
			searchContext.setStart(start);
			searchContext.setUserId(userId);

			//TODO -- make this configurable
			String queryString = "http://DNS  index.DNS   /search/kv/va_search_xml.jsp?QT=" + keywords + "&SQ=mhvr-lp.myhealth.DNS   &DB=5";
//			String queryString = "http://localhost:8081/search";
			
			HTTPResponseBean bean = SimpleSender.send(HTTPMethod.GET, MimeType.XML, queryString, null, null);

			if (bean == null) {
				_log.error("Did not receive a response from the sender.");

				return null;
			}
			
			String xml = bean.getResponseBody();
			
			org.jdom2.Document xmlDoc = XmlHelper.parseString(xml);
			XPathSelector selector = new XPathSelector();
			Content matches = selector.selectFirst((org.jdom2.Element)xmlDoc.getRootElement(), "//matches");
			Integer totalMatches = new Integer(0);
			if( matches != null ) {
				String matchesValue = matches.getValue();
				if( matchesValue != null ) {
					totalMatches = new Integer(matchesValue);
					 
				}
			}

			String searchPath = "searchPath";
			format = "atom";
			String[] queryTerms = new String[]{keywords};
			if( totalMatches > 0 ) {
				selector = new XPathSelector();
				xmlDoc = XmlHelper.parseString(xml);

				List<Content> contentList = selector.selectAll((org.jdom2.Element)xmlDoc.getRootElement(), "//result");
				com.liferay.portal.kernel.xml.Document doc = null;
				
				if( contentList != null && contentList.size() > 0 ) {
					int total = contentList.size();//results.getLength();
					Object[] values = addSearchResults(
							queryTerms, keywords, startPage, itemsPerPage, total, start,
							"Enterprise Search Title", searchPath, format, themeDisplay);

					doc = (com.liferay.portal.kernel.xml.Document)values[0];
					Element root = (Element)values[1];
					int count = 0;
					for( Content c : contentList ) {
						Date d = new Date();

						Content title = selector.selectFirst(c, "result_title");
						String titleValue = title.getValue();

						Content url = selector.selectFirst(c, "result_url");
						String urlValue = url.getValue();
						
						Content description = selector.selectFirst(c, "result_description");
						String descriptionValue = description.getValue();
						
						addSearchResult(
								root, 1, 1, "entryClassName",
								1, titleValue, urlValue, d, descriptionValue, 0.0, format);					
						count++;
						if( count == itemsPerPage ) {
							break;
						}
					}
				} 
				
				if (_log.isDebugEnabled()) {
					_log.debug("Return\n" + doc.asXML());
				}
				return doc.asXML();				
			} else {
				int total = totalMatches;
				com.liferay.portal.kernel.xml.Document doc = null;

				Object[] values = addSearchResults(
						queryTerms, keywords, startPage, itemsPerPage, total, start,
						"Enterprise Search Title", searchPath, format, themeDisplay);
				doc = (com.liferay.portal.kernel.xml.Document)values[0];
				return doc.asXML();				
			}
		}
		catch (Exception e) {
			throw new SearchException(e);
		}
	}

	private static Log _log = LogFactoryUtil.getLog(EnterpriseSearch.class);
}
