package gov.va.med.mhv.util.xml;

import java.util.LinkedHashMap;
import java.util.Map;

import org.jdom2.Content;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;

public class XPathSelectExpr<T extends Content>
{
	public String expr;
	public Filter<T> filter;
	public XPathExpression<T> xe;

	public XPathSelectExpr(String expr) {
		this(expr, (Filter<T>) Filters.content());
	}

	public XPathSelectExpr(String expr, Filter<T> filter) {
		this(expr, filter, true);
	}

	public XPathSelectExpr(String expr, Filter<T> filter, boolean firstMatching) {
		if (expr == null) {
			throw new IllegalArgumentException("An xpath-expression cannot be null.");
		}
		if (filter == null) {
			throw new IllegalArgumentException("A return-type filter cannot be null.");
		}
		this.expr = expr;
		this.filter = filter;
	}

	/* Produce an XPathSelectExpr from a simple String map, defaulting the Filter type to any content, and selecting the first matching.
	 */
	public static Map<String,XPathSelectExpr<Content>> itemsForExprs(Map<String,String> exprMap)
	{
		// this uses a LinkedHashMap to preserve ordering in case it matters to the caller
		Map<String,XPathSelectExpr<Content>> selectMap = new LinkedHashMap<String,XPathSelectExpr<Content>>();
		for (Map.Entry<String,String> e : exprMap.entrySet()) {
			selectMap.put(e.getKey(), new XPathSelectExpr<Content>(e.getValue()));
		}
		return selectMap;
	}

	public String toString() {
		return this.expr;
	}
}
