package gov.va.med.mhv.util.distributor.message;

public enum MimeType {
	
	//There are many more MIME types please add as you need others.
	HTML("text/html"),
	XML("application/xml"),
	JSON("application/json"),
	XMLTEXT("text/xml"),
	TEXT("text/plain"),
	BMP("image/bmp"),
	GIF("image/gif"),
	JPG("image/jpeg"),
	BINARY("application/octet-stream"),
	ZIP("application/x-compressed"),
	CERT("application/x-x509-ca-cert"),
	JAVASCRIPT("application/javascript"),
	MIXED("multipart/mixed"),
	URLENCODED("application/x-www-form-urlencoded");

	private String mimeType;

	MimeType(String desc){
		this.mimeType = desc;
	}

	public String mimeValue(){
		return mimeType;
	}

	@Override
	public String toString(){
		return mimeType;
	}
}
