package gov.va.med.mhv.util.distributor.message;

import java.io.InputStream;
import java.util.Map;

/**
 * Interface for Request messages that are sent from the Distributor classes.
 *
 */
public class BaseRequest {

	protected String body ;
	protected String user ;
	protected String uri;
	protected String sslTrustStoreLocation;
	protected String sslKeyStoreLocation;
	
	protected char[] password;
	protected char[] sslTrustStorePassword;
	protected char[] sslKeyStorePassword;
	
	protected int retryAttempts;
	protected long timeout;
	
	protected InputStream inputStream ;
	protected Map<String, ?> properties ;
	protected MimeType mimeType;
	
	/**
	 * Password used for authentication into the client system
	 * @return
	 */
	public char[] getPassword() {
		return password;
	}

    /**
     * User name used for authentication into the client system
     * @return
     */
	public String getUsername() {
		return user;
	}

    /**
     * The body of the message that will be distributed to the client
     * @return
     */
	public String getBody() {
		return body;
	}

    /**
     * The body of the message that will be distributed to the client
     * @return
     */
	public InputStream getInputStream(){
		return inputStream;
	}
	
    /**
     * Any properties that need to be included into the message
     * @return
     */
	public Map<String,?> getProperties() {
		return properties;
	}

    /**
     * Location of the SSL Trust store if a certificate based communication is required
     * @return
     */
	public String getSslTrustStoreLocation() {
		return sslTrustStoreLocation;
	}

	/**
     * Location of the SSL Key store if a certificate based communication is required
     * @return
     */
	public String getSslKeyStoreLocation() {
		return sslKeyStoreLocation;
	}	
	
    /**
     * The Password of the SSL Trust store used if certificate based communication is required
     * @return
     */
	public char[] getSslTrustStorePassword() {
		return sslTrustStorePassword;
	}

	/**
     * The Password of the SSL Trust store used if certificate based communication is required
     * @return
     */
	public char[] getSslKeyStorePassword() {
		return sslKeyStorePassword;
	}
	
    /**
     * The URI that the system will be distributing the message to.
     * @return
     */
	public String getUri() {
		return uri;
	}
	
    /**
     * Number of times the system will attempt the connection before giving up.
     * @return
     */
	public int getRetryAttempts() {
		return retryAttempts;
	}
    
    /**
     * The amount of time it will try to complete the connection
     * @return
     */
	public long getRetryTimeout() {
		return timeout;
	}
	
	/**
	 * Returns the MIME type set in the HTTP Headers
	 * @return
	 */
	public MimeType getMimeType(){
		return mimeType;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public void setSslKeyStoreLocation(String sslKeyStoreLocation) {
		this.sslKeyStoreLocation = sslKeyStoreLocation;
	}

	public void setSslKeyStorePassword(char[] sslKeyStorePassword) {
		this.sslKeyStorePassword = sslKeyStorePassword;
	}
	
	public void setSslTrustStorePassword(char[] sslTrustStorePassword) {
		this.sslTrustStorePassword = sslTrustStorePassword;
	}

	public void setSslTruststoreLocation(String sslTruststoreLocation) {
		this.sslTrustStoreLocation = sslTruststoreLocation;
	}
	
	public long getTimeout() {
		return timeout;
	}

	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public void setPassword(char[] password) {
		this.password = password;
	}

	public void setRetryAttempts(int retryAttempts) {
		this.retryAttempts = retryAttempts;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public void setProperties(Map<String, ?> properties) {
		this.properties = properties;
	}

	public void setMimeType(MimeType mimeType) {
		this.mimeType = mimeType;
	}
}
