package gov.va.med.mhv.common.data.model;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "USER_PROFILE")
public class UserProfile extends AbstractBaseEntity {

	private static final long serialVersionUID = 752388229562277990L;

	@Id
	@Column(name = "USER_PROFILE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@ManyToMany(fetch = FetchType.EAGER)
	@JoinTable(name = "USER_PROFILE_ACCESS_ROLE",
		joinColumns = {@JoinColumn(name = "USER_PROFILE_ID")},
		inverseJoinColumns = {@JoinColumn(name = "ACCESS_ROLE_ID")})
	@Fetch(FetchMode.SELECT)
	private List<AccessRole> accessRoles;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "USER_NAME")
	private String userName;

	@Column(name = "ACCEPT_DISCLAIMER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean acceptDisclaimer;

	@Column(name = "ACCEPT_PRIVACY", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean acceptPrivacy;

	@Column(name = "ACCEPT_SM_TERMS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean acceptSMTerms;

	@Column(name = "ACCEPT_TERMS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean acceptTerms;

	@Column(name = "ADDRESS_CITY")
	private String addressCity;

	@Column(name = "ADDRESS_COUNTRY")
	private String addressCountry;

	@Column(name = "ADDRESS_POSTAL_CODE")
	private String addressPostalCode;

	@Column(name = "ADDRESS_PROVINCE")
	private String addressProvince;

	@Column(name = "ADDRESS_STATE")
	private String addressState;

	@Column(name = "ADDRESS_STREET_1")
	private String addressStreet1;

	@Column(name = "ADDRESS_STREET_2")
	private String addressStreet2;

	@Column(name = "ALTERNATE_ADDRESS_CITY")
	private String alternateAddressCity;

	@Column(name = "ALTERNATE_ADDRESS_COUNTRY")
	private String alternateAddressCountry;

	@Column(name = "ALTERNATE_ADDRESS_POSTAL_CODE")
	private String alternateAddressPostalCode;

	@Column(name = "ALTERNATE_ADDRESS_PROVINCE")
	private String alternateAddressProvince;

	@Column(name = "ALTERNATE_ADDRESS_STATE")
	private String alternateAddressState;

	@Column(name = "ALTERNATE_ADDRESS_STREET_1")
	private String alternateAddressStreet1;

	@Column(name = "ALTERNATE_ADDRESS_STREET_2")
	private String alternateAddressStreet2;

	@Column(name = "AUTO_AUTH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean autoAuth;

	@Column(name = "AUTO_AUTH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date autoAuthDate;

	@Column(name = "BIRTH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date birthDate;

	@Column(name = "BLOOD_TYPE")
	private String bloodType;

	@Column(name = "CONFIRMATION_LOCK_OUT", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean confirmationLockOut;

	@Column(name = "CONTACT_INFO_CONTACT_METHOD")
	private String contactInfoContactMethod;

	@Column(name = "CONTACT_INFO_EMAIL")
	private String contactInfoEmail;

	@Column(name = "CONTACT_INFO_FAX")
	private String contactInfoFax;

	@Column(name = "CONTACT_INFO_HOME_PHONE")
	private String contactInfoHomePhone;

	@Column(name = "CONTACT_INFO_MOBILE_PHONE")
	private String contactInfoMobilePhone;

	@Column(name = "CONTACT_INFO_PAGER")
	private String contactInfoPager;

	@Column(name = "CONTACT_INFO_WORK_PHONE")
	private String contactInfoWorkPhone;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "CURRENT_LOGIN")
	@Temporal(TemporalType.TIMESTAMP)
	private Date currentLogin;

	@Column(name = "CURRENT_OCCUPATION")
	private String currentOccupation;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_DEACT_REASON_ID")
	@Fetch(FetchMode.SELECT)
	private UserProfileDeactivationReason deactivationReason;

	@Column(name = "DEATH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date deathDate;

	@Column(name = "EHR_ACCESS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean ehrAccess;

	@Column(name = "EMAIL_CREDENTIALS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean emailCredentials;

	@Column(name = "EMAIL_HEALTH_AWARENESS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean emailHealthAwareness;

	// mapped figure it out
	// @Column(name = "EMERGENCY_CONTACTS")
	// @Transient
	// private Set emergencyContacts;

	@Column(name = "FIRST_NAME")
	private String firstName;

	@Column(name = "GENDER")
	private String gender;

	@Column(name = "INTEREST_ALCOHOL", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestAlcohol;

	@Column(name = "RX_TRACKING_EMAIL_PREF", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean rxTrackingEmailPref;

	@Column(name = "VA_APPT_EMAIL_PREF", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean apptReminderEmailPref;

	@Column(name = "VA_BBMI_EMAIL_PREF", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean bbmiEmailPref;
	
	@Column(name = "HEALTH_SUMMARY_SENT_EMAIL_PREF", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean healthSummarySentEmailPref;
	
	@Column(name = "INTEREST_BLOOD_PRESSURE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestBloodPressure;

	@Column(name = "INTEREST_DEPRESSION", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestDepression;

	@Column(name = "INTEREST_DIABETES", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestDiabetes;

	@Column(name = "INTEREST_DIET", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestDiet;

	@Column(name = "INTEREST_EXERCISE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestExercise;

	@Column(name = "INTEREST_HEART", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestHeart;

	@Column(name = "INTEREST_MILITARY_RELATED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestMilitaryRelated;

	@Column(name = "INTEREST_PTSD", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestPTSD;

	@Column(name = "INTEREST_REMINDER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestReminder;

	@Column(name = "INTEREST_SMOKING", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestSmoking;

	@Column(name = "INTEREST_STRESS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean interestStress;

	@Column(name = "IS_ADMINISTRATOR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isAdministrator;

	@Column(name = "IS_EMPLOYEE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isEmployee;

	@Column(name = "IS_HEALTH_CARE_PROVIDER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isHealthCareProvider;

	@Column(name = "IS_MPI_CONTROLLED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isMPIControlled;

	@Column(name = "IS_ORGAN_DONOR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isOrganDonor;

	@Column(name = "IS_OTHER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isOther;

	@Column(name = "IS_PATIENT", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isPatient;

	@Column(name = "IS_PATIENT_ADVOCATE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isPatientAdvocate;

	@Column(name = "IS_VETERAN", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isVeteran;

	@Column(name = "IS_CHAMPVA_BENEFICIARY", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isChampVABeneficiary;
	
	@Column(name = "IS_SERVICE_MEMBER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isServiceMember;

	@Column(name = "LAST_LOGIN")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastLogin;

	@Column(name = "LAST_NAME")
	private String lastName;

	@Column(name = "LOCK_COUNT")
	private Integer lockCount;

	@Column(name = "LOCK_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lockDate;

	@Column(name = "MARITAL_STATUS")
	private String maritalStatus;

	@Column(name = "MHV_ID")
	private String mhvId;

	@Column(name = "MIDDLE_NAME")
	private String middleName;

	@Column(name = "ORIENTATION_VIDEO_VIEW", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean orientationVideoView;

	@Column(name = "PARTICIPATION_FORM_SIGN", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean participationFormSign;

	@Column(name = "PASSWORD_HINT_ANSWER_1")
	private String passwordHintAnswer1;

	@Column(name = "PASSWORD_HINT_ANSWER_2")
	private String passwordHintAnswer2;

	@Column(name = "PASSWORD_HINT_QUESTION_1")
	private Integer passwordHintQuestion1;

	@Column(name = "PASSWORD_HINT_QUESTION_2")
	private Integer passwordHintQuestion2;

	@Column(name = "PASSWORD_LAST_CHANGED")
	@Temporal(TemporalType.TIMESTAMP)
	private Date passwordLastChanged;

	// PASSWORD_LOCKOUT column is not in database -- research
	// @Column(name = "PASSWORD_LOCKOUT", columnDefinition = "NUMBER" )
	// @Transient
	// private Boolean passwordLockOut;

	@Column(name = "PHYSICAL_PROOF", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean physicalProof;

	// NEEDS TO MAP ?? can't find class
	@Column(name = "PROOF_INSTITUTION_ID")
	private Integer proofInstitutionId;

	@Column(name = "PROOF_LEVEL")
	private String proofLevel;

	@Column(name = "PROOF_LEVEL_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date proofLevelDate;

	@Column(name = "RX_AGREEMENT_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date rxAgreementDate;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "FCCX")
	@Temporal(TemporalType.TIMESTAMP)
	private Date fccx;

	@Column(name = "RX_AGREEMENT_SIGNED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean rxAgreementSigned;

	@Column(name = "SSN")
	private String ssn;

	@Column(name = "SUFFIX")
	private String suffix;

	@Column(name = "TEMPORARY_PASSWORD", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean temporaryPassword;

	@Column(name = "TITLE")
	private String title;

	@Column(name = "USER_ALIAS")
	private String userAlias;

	@Column(name = "IMPRECISE_BIRTH_DATE")
	private String impreciseBirthDate;
	
	@Column(name = "SIGN_IN_PARTNERS")
	private String signInPartners;
	
	@Column(name = "RESTRICT_SIP_ACCESS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean restrictSIPAccess;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public Boolean getAcceptDisclaimer() {
		return acceptDisclaimer;
	}

	public void setAcceptDisclaimer(Boolean acceptDisclaimer) {
		this.acceptDisclaimer = acceptDisclaimer;
	}

	public Boolean getAcceptPrivacy() {
		return acceptPrivacy;
	}

	public void setAcceptPrivacy(Boolean acceptPrivacy) {
		this.acceptPrivacy = acceptPrivacy;
	}

	public Boolean getAcceptSMTerms() {
		return acceptSMTerms;
	}

	public void setAcceptSMTerms(Boolean acceptSMTerms) {
		this.acceptSMTerms = acceptSMTerms;
	}

	public Boolean getAcceptTerms() {
		return acceptTerms;
	}

	public void setAcceptTerms(Boolean acceptTerms) {
		this.acceptTerms = acceptTerms;
	}

	public String getAddressCity() {
		return addressCity;
	}

	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}

	public String getAddressCountry() {
		return addressCountry;
	}

	public void setAddressCountry(String addressCountry) {
		this.addressCountry = addressCountry;
	}

	public String getAddressPostalCode() {
		return addressPostalCode;
	}

	public void setAddressPostalCode(String addressPostalCode) {
		this.addressPostalCode = addressPostalCode;
	}

	public String getAddressProvince() {
		return addressProvince;
	}

	public void setAddressProvince(String addressProvince) {
		this.addressProvince = addressProvince;
	}

	public String getAddressState() {
		return addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAddressStreet1() {
		return addressStreet1;
	}

	public void setAddressStreet1(String addressStreet1) {
		this.addressStreet1 = addressStreet1;
	}

	public String getAddressStreet2() {
		return addressStreet2;
	}

	public void setAddressStreet2(String addressStreet2) {
		this.addressStreet2 = addressStreet2;
	}

	public String getAlternateAddressCity() {
		return alternateAddressCity;
	}

	public void setAlternateAddressCity(String alternateAddressCity) {
		this.alternateAddressCity = alternateAddressCity;
	}

	public String getAlternateAddressCountry() {
		return alternateAddressCountry;
	}

	public void setAlternateAddressCountry(String alternateAddressCountry) {
		this.alternateAddressCountry = alternateAddressCountry;
	}

	public String getAlternateAddressPostalCode() {
		return alternateAddressPostalCode;
	}

	public void setAlternateAddressPostalCode(String alternateAddressPostalCode) {
		this.alternateAddressPostalCode = alternateAddressPostalCode;
	}

	public String getAlternateAddressProvince() {
		return alternateAddressProvince;
	}

	public void setAlternateAddressProvince(String alternateAddressProvince) {
		this.alternateAddressProvince = alternateAddressProvince;
	}

	public String getAlternateAddressState() {
		return alternateAddressState;
	}

	public void setAlternateAddressState(String alternateAddressState) {
		this.alternateAddressState = alternateAddressState;
	}

	public String getAlternateAddressStreet1() {
		return alternateAddressStreet1;
	}

	public void setAlternateAddressStreet1(String alternateAddressStreet1) {
		this.alternateAddressStreet1 = alternateAddressStreet1;
	}

	public String getAlternateAddressStreet2() {
		return alternateAddressStreet2;
	}

	public void setAlternateAddressStreet2(String alternateAddressStreet2) {
		this.alternateAddressStreet2 = alternateAddressStreet2;
	}

	public Boolean getAutoAuth() {
		return autoAuth;
	}

	public void setAutoAuth(Boolean autoAuth) {
		this.autoAuth = autoAuth;
	}

	public Date getAutoAuthDate() {
		return autoAuthDate;
	}

	public void setAutoAuthDate(Date autoAuthDate) {
		this.autoAuthDate = autoAuthDate;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getBloodType() {
		return bloodType;
	}

	public void setBloodType(String bloodType) {
		this.bloodType = bloodType;
	}

	public Boolean getConfirmationLockOut() {
		return confirmationLockOut;
	}

	public void setConfirmationLockOut(Boolean confirmationLockOut) {
		this.confirmationLockOut = confirmationLockOut;
	}

	public String getContactInfoContactMethod() {
		return contactInfoContactMethod;
	}

	public void setContactInfoContactMethod(String contactInfoContactMethod) {
		this.contactInfoContactMethod = contactInfoContactMethod;
	}

	public String getContactInfoEmail() {
		return contactInfoEmail;
	}

	public void setContactInfoEmail(String contactInfoEmail) {
		this.contactInfoEmail = contactInfoEmail;
	}

	public String getContactInfoFax() {
		return contactInfoFax;
	}

	public void setContactInfoFax(String contactInfoFax) {
		this.contactInfoFax = contactInfoFax;
	}

	public String getContactInfoHomePhone() {
		return contactInfoHomePhone;
	}

	public void setContactInfoHomePhone(String contactInfoHomePhone) {
		this.contactInfoHomePhone = contactInfoHomePhone;
	}

	public String getContactInfoMobilePhone() {
		return contactInfoMobilePhone;
	}

	public void setContactInfoMobilePhone(String contactInfoMobilePhone) {
		this.contactInfoMobilePhone = contactInfoMobilePhone;
	}

	public String getContactInfoPager() {
		return contactInfoPager;
	}

	public void setContactInfoPager(String contactInfoPager) {
		this.contactInfoPager = contactInfoPager;
	}

	public String getContactInfoWorkPhone() {
		return contactInfoWorkPhone;
	}

	public void setContactInfoWorkPhone(String contactInfoWorkPhone) {
		this.contactInfoWorkPhone = contactInfoWorkPhone;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	/*
	 * public Date getCurrentLogin() { return currentLogin; }
	 *
	 * public void setCurrentLogin(Date currentLogin) { this.currentLogin =
	 * currentLogin; }
	 */
	public String getCurrentOccupation() {
		return currentOccupation;
	}

	public void setCurrentOccupation(String currentOccupation) {
		this.currentOccupation = currentOccupation;
	}

	public Boolean getEhrAccess() {
		return ehrAccess;
	}

	public void setEhrAccess(Boolean ehrAccess) {
		this.ehrAccess = ehrAccess;
	}

	public Boolean getEmailCredentials() {
		return emailCredentials;
	}

	public void setEmailCredentials(Boolean emailCredentials) {
		this.emailCredentials = emailCredentials;
	}

	public Boolean getEmailHealthAwareness() {
		return emailHealthAwareness;
	}

	public void setEmailHealthAwareness(Boolean emailHealthAwareness) {
		this.emailHealthAwareness = emailHealthAwareness;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public Boolean getInterestAlcohol() {
		return interestAlcohol;
	}

	public void setInterestAlcohol(Boolean interestAlcohol) {
		this.interestAlcohol = interestAlcohol;
	}

	public Boolean getInterestBloodPressure() {
		return interestBloodPressure;
	}

	public void setInterestBloodPressure(Boolean interestBloodPressure) {
		this.interestBloodPressure = interestBloodPressure;
	}

	public Boolean getInterestDepression() {
		return interestDepression;
	}

	public void setInterestDepression(Boolean interestDepression) {
		this.interestDepression = interestDepression;
	}

	public Boolean getInterestDiabetes() {
		return interestDiabetes;
	}

	public void setInterestDiabetes(Boolean interestDiabetes) {
		this.interestDiabetes = interestDiabetes;
	}

	public Boolean getInterestDiet() {
		return interestDiet;
	}

	public void setInterestDiet(Boolean interestDiet) {
		this.interestDiet = interestDiet;
	}

	public Boolean getInterestExercise() {
		return interestExercise;
	}

	public void setInterestExercise(Boolean interestExercise) {
		this.interestExercise = interestExercise;
	}

	public Boolean getInterestHeart() {
		return interestHeart;
	}

	public void setInterestHeart(Boolean interestHeart) {
		this.interestHeart = interestHeart;
	}

	public Boolean getInterestMilitaryRelated() {
		return interestMilitaryRelated;
	}

	public void setInterestMilitaryRelated(Boolean interestMilitaryRelated) {
		this.interestMilitaryRelated = interestMilitaryRelated;
	}

	public Boolean getInterestPTSD() {
		return interestPTSD;
	}

	public void setInterestPTSD(Boolean interestPTSD) {
		this.interestPTSD = interestPTSD;
	}

	public Boolean getInterestReminder() {
		return interestReminder;
	}

	public void setInterestReminder(Boolean interestReminder) {
		this.interestReminder = interestReminder;
	}

	public Boolean getInterestSmoking() {
		return interestSmoking;
	}

	public void setInterestSmoking(Boolean interestSmoking) {
		this.interestSmoking = interestSmoking;
	}

	public Boolean getInterestStress() {
		return interestStress;
	}

	public void setInterestStress(Boolean interestStress) {
		this.interestStress = interestStress;
	}

	public Boolean getIsAdministrator() {
		return isAdministrator;
	}

	public void setIsAdministrator(Boolean isAdministrator) {
		this.isAdministrator = isAdministrator;
	}

	public Boolean getIsEmployee() {
		return isEmployee;
	}

	public void setIsEmployee(Boolean isEmployee) {
		this.isEmployee = isEmployee;
	}

	public Boolean getIsHealthCareProvider() {
		return isHealthCareProvider;
	}

	public void setIsHealthCareProvider(Boolean isHealthCareProvider) {
		this.isHealthCareProvider = isHealthCareProvider;
	}

	public Boolean getIsMPIControlled() {
		return isMPIControlled;
	}

	public void setIsMPIControlled(Boolean isMPIControlled) {
		this.isMPIControlled = isMPIControlled;
	}

	public Boolean getIsOrganDonor() {
		return isOrganDonor;
	}

	public void setIsOrganDonor(Boolean isOrganDonor) {
		this.isOrganDonor = isOrganDonor;
	}

	public Boolean getIsOther() {
		return isOther;
	}

	public void setIsOther(Boolean isOther) {
		this.isOther = isOther;
	}

	public Boolean getIsPatient() {
		return isPatient;
	}

	public void setIsPatient(Boolean isPatient) {
		this.isPatient = isPatient;
	}

	public Boolean getIsPatientAdvocate() {
		return isPatientAdvocate;
	}

	public void setIsPatientAdvocate(Boolean isPatientAdvocate) {
		this.isPatientAdvocate = isPatientAdvocate;
	}

	public Boolean getIsVeteran() {
		return isVeteran;
	}

	public void setIsVeteran(Boolean isVeteran) {
		this.isVeteran = isVeteran;
	}

	public Boolean getIsChampVABeneficiary() {
		return isChampVABeneficiary;
	}
	
	public void setIsChampVABeneficiary(Boolean isChampVABeneficiary) {
		this.isChampVABeneficiary = isChampVABeneficiary;
	}
	
	public Boolean getIsServiceMember() {
		return isServiceMember;
	}
	
	public void setIsServiceMember(Boolean isServiceMember) {
		this.isServiceMember = isServiceMember;
	}
		
	public Date getLastLogin() {
		return lastLogin;
	}

	public void setLastLogin(Date lastLogin) {
		this.lastLogin = lastLogin;
	}

	public Integer getLockCount() {
		return lockCount;
	}

	public void setLockCount(Integer lockCount) {
		this.lockCount = lockCount;
	}

	public Date getLockDate() {
		return lockDate;
	}

	public void setLockDate(Date lockDate) {
		this.lockDate = lockDate;
	}

	public String getMaritalStatus() {
		return maritalStatus;
	}

	public void setMaritalStatus(String maritalStatus) {
		this.maritalStatus = maritalStatus;
	}

	public String getMhvId() {
		return mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public Boolean getOrientationVideoView() {
		return orientationVideoView;
	}

	public void setOrientationVideoView(Boolean orientationVideoView) {
		this.orientationVideoView = orientationVideoView;
	}

	public Boolean getParticipationFormSign() {
		return participationFormSign;
	}

	public void setParticipationFormSign(Boolean participationFormSign) {
		this.participationFormSign = participationFormSign;
	}

	public String getPasswordHintAnswer1() {
		return passwordHintAnswer1;
	}

	public void setPasswordHintAnswer1(String passwordHintAnswer1) {
		this.passwordHintAnswer1 = passwordHintAnswer1;
	}

	public String getPasswordHintAnswer2() {
		return passwordHintAnswer2;
	}

	public void setPasswordHintAnswer2(String passwordHintAnswer2) {
		this.passwordHintAnswer2 = passwordHintAnswer2;
	}

	public Integer getPasswordHintQuestion1() {
		return passwordHintQuestion1;
	}

	public void setPasswordHintQuestion1(Integer passwordHintQuestion1) {
		this.passwordHintQuestion1 = passwordHintQuestion1;
	}

	public Integer getPasswordHintQuestion2() {
		return passwordHintQuestion2;
	}

	public void setPasswordHintQuestion2(Integer passwordHintQuestion2) {
		this.passwordHintQuestion2 = passwordHintQuestion2;
	}

	public Date getPasswordLastChanged() {
		return passwordLastChanged;
	}

	public void setPasswordLastChanged(Date passwordLastChanged) {
		this.passwordLastChanged = passwordLastChanged;
	}

	public Boolean getPhysicalProof() {
		return physicalProof;
	}

	public void setPhysicalProof(Boolean physicalProof) {
		this.physicalProof = physicalProof;
	}

	public Integer getProofInstitutionId() {
		return proofInstitutionId;
	}

	public void setProofInstitutionId(Integer proofInstitutionId) {
		this.proofInstitutionId = proofInstitutionId;
	}

	public String getProofLevel() {
		return proofLevel;
	}

	public void setProofLevel(String proofLevel) {
		this.proofLevel = proofLevel;
	}

	public Date getProofLevelDate() {
		return proofLevelDate;
	}

	public void setProofLevelDate(Date proofLevelDate) {
		this.proofLevelDate = proofLevelDate;
	}

	public Date getRxAgreementDate() {
		return rxAgreementDate;
	}

	public void setRxAgreementDate(Date rxAgreementDate) {
		this.rxAgreementDate = rxAgreementDate;
	}

	public Boolean getRxAgreementSigned() {
		return rxAgreementSigned;
	}

	public void setRxAgreementSigned(Boolean rxAgreementSigned) {
		this.rxAgreementSigned = rxAgreementSigned;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public Boolean getTemporaryPassword() {
		return temporaryPassword;
	}

	public void setTemporaryPassword(Boolean temporaryPassword) {
		this.temporaryPassword = temporaryPassword;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUserAlias() {
		return userAlias;
	}

	public void setUserAlias(String userAlias) {
		this.userAlias = userAlias;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Date getCurrentLogin() {
		return currentLogin;
	}

	public void setCurrentLogin(Date currentLogin) {
		this.currentLogin = currentLogin;
	}

	public Date getDeathDate() {
		return deathDate;
	}

	public void setDeathDate(Date deathDate) {
		this.deathDate = deathDate;
	}

	public Boolean getRxTrackingEmailPref() {
		return rxTrackingEmailPref;
	}

	public void setRxTrackingEmailPref(Boolean rxTrackingEmailPref) {
		this.rxTrackingEmailPref = rxTrackingEmailPref;
	}

	public Boolean getApptReminderEmailPref() {
		return apptReminderEmailPref;
	}

	public void setApptReminderEmailPref(Boolean apptReminderEmailPref) {
		this.apptReminderEmailPref = apptReminderEmailPref;
	}
	
	public Boolean getBbmiEmailPref() {
		return bbmiEmailPref;
	}

	public void setBbmiEmailPref(Boolean bbmiEmailPref) {
		this.bbmiEmailPref = bbmiEmailPref;
	}

	public Boolean getHealthSummarySentEmailPref() {
		return healthSummarySentEmailPref;
	}
	
	public void setHealthSummarySentEmailPref(Boolean healthSummarySentEmailPref) {
		this.healthSummarySentEmailPref = healthSummarySentEmailPref;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Date getFccx() {
		return fccx;
	}

	public void setFccx(Date fccx) {
		this.fccx = fccx;
	}

	public List<AccessRole> getAccessRoles() {
		return accessRoles;
	}

	public void setAccessRoles(List<AccessRole> accessRoles) {
		this.accessRoles = accessRoles;
	}

	public UserProfileDeactivationReason getDeactivationReason() {
		return deactivationReason;
	}

	public void setDeactivationReason(UserProfileDeactivationReason deactivationReason) {
		this.deactivationReason = deactivationReason;
	}

	public String getImpreciseBirthDate() {
		return impreciseBirthDate;
	}

	public void setImpreciseBirthDate(String impreciseBirthDate) {
		this.impreciseBirthDate = impreciseBirthDate;
	}
	
	public String getSignInPartners() {
		return signInPartners;
	}

	public void setSignInPartners(String signInPartners) {
		this.signInPartners = signInPartners;
	}
	
	public Boolean getRestrictSIPAccess() {
		return restrictSIPAccess;
	}

	public void setRestrictSIPAccesss(Boolean restrictSIPAccess) {
		this.restrictSIPAccess = restrictSIPAccess;
	}

}
