package gov.va.med.mhv.common.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "PATIENT_REGISTRY_CHANGE")
public class PatientRegistryChange extends AbstractBaseEntity {
	private static final long serialVersionUID = 2783609252071444046L;

	@Id
	@Column(name = "PATIENT_REGISTRY_CHANGE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "OLD_LAST_NAME")
	private String oldLastName;

	@Column(name = "OLD_ADDRESS_PROVINCE")
	private String oldAddressProvince;

	@Column(name = "OLD_FIRST_NAME")
	private String oldFirstName;

	@Column(name = "OLD_ADDRESS_STREET2")
	private String oldAddressStreet2;

	@Column(name = "OLD_GENDER")
	private String oldGender;

	@Column(name = "OLD_BIRTH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date oldBirthDate;

	@Column(name = "OLD_SSN")
	private String oldSsn;

	@Column(name = "OLD_ADDRESS_CITY")
	private String oldAddressCity;

	@Column(name = "RECORDED_ON_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date recordedOnDate;

	@Column(name = "OLD_ADDRESS_STREET1")
	private String oldAddressStreet1;

	@Column(name = "OLD_ICN")
	private String oldIcn;

	@Column(name = "OLD_NAME_SUFFIX")
	private String oldNameSuffix;

	@Column(name = "OLD_NAME_PREFIX")
	private String oldNamePrefix;

	@Column(name = "OLD_MIDDLE_NAME")
	private String oldMiddleName;

	@Column(name = "OLD_ADDRESS_POSTALCODE")
	private String oldAddressPostalCode;

	@Column(name = "OLD_CONTACT_INFO_HOME_PHONE")
	private String oldContactInfoHomePhone;

	@Column(name = "OLD_FACILITY_COUNT")
	private Integer oldFacilityCount;

	@Column(name = "OLD_ADDRESS_COUNTRY")
	private String oldAddressCountry;

	@Column(name = "OLD_ADDRESS_STATE")
	private String oldAddressState;

	@Column(name = "PATIENT_ID", insertable = false, updatable = false)
	private Long patientId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PATIENT_ID")
	private Patient patient;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getOldLastName() {
		return oldLastName;
	}

	public void setOldLastName(String oldLastName) {
		this.oldLastName = oldLastName;
	}

	public String getOldAddressProvince() {
		return oldAddressProvince;
	}

	public void setOldAddressProvince(String oldAddressProvince) {
		this.oldAddressProvince = oldAddressProvince;
	}

	public String getOldFirstName() {
		return oldFirstName;
	}

	public void setOldFirstName(String oldFirstName) {
		this.oldFirstName = oldFirstName;
	}

	public String getOldAddressStreet2() {
		return oldAddressStreet2;
	}

	public void setOldAddressStreet2(String oldAddressStreet2) {
		this.oldAddressStreet2 = oldAddressStreet2;
	}

	public String getOldGender() {
		return oldGender;
	}

	public void setOldGender(String oldGender) {
		this.oldGender = oldGender;
	}

	public Date getOldBirthDate() {
		return oldBirthDate;
	}

	public void setOldBirthDate(Date oldBirthDate) {
		this.oldBirthDate = oldBirthDate;
	}

	public String getOldSsn() {
		return oldSsn;
	}

	public void setOldSsn(String oldSsn) {
		this.oldSsn = oldSsn;
	}

	public String getOldAddressCity() {
		return oldAddressCity;
	}

	public void setOldAddressCity(String oldAddressCity) {
		this.oldAddressCity = oldAddressCity;
	}

	public Date getRecordedOnDate() {
		return recordedOnDate;
	}

	public void setRecordedOnDate(Date recordedOnDate) {
		this.recordedOnDate = recordedOnDate;
	}

	public String getOldAddressStreet1() {
		return oldAddressStreet1;
	}

	public void setOldAddressStreet1(String oldAddressStreet1) {
		this.oldAddressStreet1 = oldAddressStreet1;
	}

	public String getOldIcn() {
		return oldIcn;
	}

	public void setOldIcn(String oldIcn) {
		this.oldIcn = oldIcn;
	}

	public String getOldNameSuffix() {
		return oldNameSuffix;
	}

	public void setOldNameSuffix(String oldNameSuffix) {
		this.oldNameSuffix = oldNameSuffix;
	}

	public String getOldNamePrefix() {
		return oldNamePrefix;
	}

	public void setOldNamePrefix(String oldNamePrefix) {
		this.oldNamePrefix = oldNamePrefix;
	}

	public String getOldMiddleName() {
		return oldMiddleName;
	}

	public void setOldMiddleName(String oldMiddleName) {
		this.oldMiddleName = oldMiddleName;
	}

	public String getOldAddressPostalCode() {
		return oldAddressPostalCode;
	}

	public void setOldAddressPostalCode(String oldAddressPostalCode) {
		this.oldAddressPostalCode = oldAddressPostalCode;
	}

	public String getOldContactInfoHomePhone() {
		return oldContactInfoHomePhone;
	}

	public void setOldContactInfoHomePhone(String oldContactInfoHomePhone) {
		this.oldContactInfoHomePhone = oldContactInfoHomePhone;
	}

	public Integer getOldFacilityCount() {
		return oldFacilityCount;
	}

	public void setOldFacilityCount(Integer oldFacilityCount) {
		this.oldFacilityCount = oldFacilityCount;
	}

	public String getOldAddressCountry() {
		return oldAddressCountry;
	}

	public void setOldAddressCountry(String oldAddressCountry) {
		this.oldAddressCountry = oldAddressCountry;
	}

	public String getOldAddressState() {
		return oldAddressState;
	}

	public void setOldAddressState(String oldAddressState) {
		this.oldAddressState = oldAddressState;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}
}
