package gov.va.med.mhv.common.data.model;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

@Entity
@Table(name = "FACILITY")
public class Facility extends AbstractBaseEntity {

	private static final long serialVersionUID = -7833854416081352428L;

	@Id
	@Column(name = "FACILITY_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "NAME")
	private String name;

	@Column(name = "PATIENT_ID", insertable = false, updatable = false)
	private Long patientId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PATIENT_ID")
	private Patient patient;

	@Column(name = "FACILITY_INFO_FACILITY_INFO_ID")
	private Long facilityInfoId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_FACILITY_INFO_ID", insertable = false, updatable = false)
	private FacilityInfo facilityInfo;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patientId = (patient != null) ? patient.getId() : null;
		this.patient = patient;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public FacilityInfo getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfo facilityInfo) {
		this.facilityInfo = facilityInfo;
		this.facilityInfoId = (facilityInfo != null) ? facilityInfo.getId() : null;
	}
}
