package gov.va.med.mhv.common.data.converter;

import gov.va.med.mhv.common.api.dto.FacilityDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.PatientRegistryChangeDTO;
import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.PatientRegistryChange;
import gov.va.med.mhv.common.data.model.UserProfile;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PatientConverter {

	@Autowired
	private FacilityConverter facilityConverter;
	
	@Autowired
	private PatientRegistryChangeConverter patientRegChangeConverter;

	@Autowired
	InPersonAuthenticationConverter inPersonAuthenticationConverter;

	@Autowired
	UserProfileConverter userProfileConverter;

	public PatientDTO convertDomainPatient(Patient patient) {
		PatientDTO patientDto = new PatientDTO();

		patientDto.setId(patient.getId());
		patientDto.setOplock(patient.getOplock());
		patientDto.setInvalidationReferenceId(patient.getInvalidationReferenceId());
		patientDto.setLastFacilitiesUpdateDateTime(patient.getLastFacilitiesUpdateDateTime());
		patientDto.setIcn(patient.getIcn());
		patientDto.setCorrelationErrorCode(patient.getCorrelationErrorCode());
		patientDto.setMatchedDateTime(patient.getMatchedDateTime());
		patientDto.setCorrelateRequestDateTime(patient.getCorrelateRequestDateTime());
		patientDto.setInvalidatedIcn(patient.getInvalidatedIcn());
		patientDto.setCorrelatedDateTime(patient.getCorrelatedDateTime());
		patientDto.setCorrelationStatus(patient.getCorrelationStatus());
		patientDto.setCorrelatedBy(patient.getCorrelatedBy());

		try {
			if (null != patient.getFacilities() && patient.getFacilities().size() > 0) {
				Set<FacilityDTO> facilitieDtos = new HashSet<FacilityDTO>();
				for (Facility facility : patient.getFacilities()) {
					facilitieDtos.add(facilityConverter.convertDomainFacility(facility));
				}
				patientDto.setFacilities(facilitieDtos);
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		if (null != patient.getPatientRegistryChanges() && patient.getPatientRegistryChanges().size() > 0) {
			Set<PatientRegistryChangeDTO> regChangeDtos = new HashSet<PatientRegistryChangeDTO>();
			for (PatientRegistryChange regChange : patient.getPatientRegistryChanges()) {
				regChangeDtos.add(patientRegChangeConverter.convertDomainPatientRegistryChange(regChange));
			}
			patientDto.setPatientRegistryChanges(regChangeDtos);
		}

		patientDto.setIpas(getIpaDTOS(patient.getIpas(), patientDto));

		patientDto.setUserProfileId(patient.getUserProfileId());
		if (null != patient.getUserProfile()) {
			patientDto.setUserProfile(userProfileConverter.convertDomainUserProfile(patient.getUserProfile()));
		}

		return patientDto;
	}

	public Patient convertDTOProfile(PatientDTO patientDto) {
		Patient patient = new Patient();
		patient.setCorrelatedBy(patientDto.getCorrelatedBy());
		patient.setCorrelatedDateTime(patientDto.getCorrelatedDateTime());
		patient.setCorrelateRequestDateTime(patientDto.getCorrelateRequestDateTime());
		patient.setCorrelationErrorCode(patientDto.getCorrelationErrorCode());
		patient.setCorrelationStatus(patientDto.getCorrelationStatus());
		patient.setIcn(patientDto.getIcn());
		patient.setId(patientDto.getId());
		patient.setInvalidatedIcn(patientDto.getInvalidatedIcn());
		patient.setInvalidationReferenceId(patientDto.getInvalidationReferenceId());
		patient.setLastFacilitiesUpdateDateTime(patientDto.getLastFacilitiesUpdateDateTime());
		patient.setMatchedDateTime(patientDto.getMatchedDateTime());
		patient.setOplock(patientDto.getOplock());
		patient.setIpas(getIpas(patientDto.getIpas()));

		if (null != patientDto.getUserProfile()) {
			patient.setUserProfile(
					userProfileConverter.convertDTOProfile(new UserProfile(), patientDto.getUserProfile()));
		}
		
		try {
			if (null != patientDto.getFacilities() && patientDto.getFacilities().size() > 0) {
				Set<Facility> facilities = new HashSet<Facility>();
				for (FacilityDTO facility : patientDto.getFacilities()) {
					facilities.add(facilityConverter.coonvertDTOFacility(facility));
				}
				patient.setFacilities(facilities);
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}

		return patient;
	}

	private Set<InPersonAuthenticationDTO> getIpaDTOS(Set<InPersonAuthentication> ipas, PatientDTO patientDTO) {
		Set<InPersonAuthenticationDTO> ipaDtos = new HashSet<InPersonAuthenticationDTO>();
		if (ipas != null) {
			for (InPersonAuthentication ipa : ipas) {
				InPersonAuthenticationDTO ipaDto = inPersonAuthenticationConverter
						.convertDomainInpersonAuthentication(ipa);
				if (null != ipaDto) {
					ipaDtos.add(ipaDto);
				}
			}
		}
		return ipaDtos;
	}

	private Set<InPersonAuthentication> getIpas(Set<InPersonAuthenticationDTO> ipaDTOs) {
		Set<InPersonAuthentication> ipas = new HashSet<InPersonAuthentication>();
		if (ipaDTOs != null) {
			for (InPersonAuthenticationDTO ipaDto : ipaDTOs) {
				InPersonAuthentication ipa = inPersonAuthenticationConverter.convertInpersonAuthenticationDTO(ipaDto);
				// add patient's info to IPA
				inPersonAuthenticationConverter.addPatientProfile(ipaDto, ipa);

				if (null != ipa) {
					ipas.add(ipa);
				}
			}
		}
		return ipas;
	}
}
