package gov.va.med.mhv.common.data.converter;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTOLight;
import gov.va.med.mhv.common.data.model.InPersonAuthenticationLight;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InPersonAuthenticationLightConverter {
	private static final FacilityInfoConveter FI_CONVERTER = new FacilityInfoConveter();
	
	private static Logger log = LogManager.getLogger(InPersonAuthenticationLightConverter.class);
	
	@Autowired
	private PatientConverter patientConverter; 

	@Autowired
	private UserProfileConverter userProfileConverter; 
	
	public InPersonAuthenticationDTOLight convertDomainInpersonAuthentication(InPersonAuthenticationLight ipa) {
		
		
		InPersonAuthenticationDTOLight ipaDTO = new InPersonAuthenticationDTOLight();
		
		ipaDTO.setApprovedForRecordsAccess(ipa.getApprovedForRecordsAccess());
		ipaDTO.setAuthenticatedBy(ipa.getAuthenticatedBy());
		ipaDTO.setAuthenticationDate(ipa.getAuthenticationDate());
		ipaDTO.setDefermentReason(ipa.getDefermentReason());
		ipaDTO.setId(ipa.getId());
		ipaDTO.setIdentificationPresented(ipa.getIdentificationPresented());
		ipaDTO.setMviAuthenticationStatus(ipa.getMviAuthenticationStatus());
		ipaDTO.setOplock(ipa.getOplock());
		ipaDTO.setParticipationFormSigned(ipa.getParticipationFormSigned());
		ipaDTO.setRemovalReason(ipa.getRemovalReason());
		ipaDTO.setSignedFormOnlineDateTime(ipa.getSignedFormOnlineDateTime());
		ipaDTO.setStartUpgradeManualDateTime(ipa.getStartUpgradeOnlineDateTime());
		ipaDTO.setStartUpgradeOnlineDateTime(ipa.getStartUpgradeOnlineDateTime());
		ipaDTO.setStatus(ipa.getStatus());
		ipaDTO.setVideoViewed(ipa.getVideoViewed());
		ipaDTO.setPatientId(ipa.getPatientId());
		return ipaDTO;
	}
	
	public InPersonAuthenticationLight convertInpersonAuthenticationDTOLight(InPersonAuthenticationDTOLight ipaDto) {
		InPersonAuthenticationLight ipa = new InPersonAuthenticationLight();
		
		ipa.setApprovedForRecordsAccess(ipaDto.getApprovedForRecordsAccess());
		ipa.setAuthenticatedBy(ipaDto.getAuthenticatedBy());
		ipa.setAuthenticationDate(ipaDto.getAuthenticationDate());
		ipa.setDefermentReason(ipaDto.getDefermentReason());
		ipa.setId(ipaDto.getId());
		ipa.setIdentificationPresented(ipaDto.getIdentificationPresented());
		ipa.setMviAuthenticationStatus(ipaDto.getMviAuthenticationStatus());
		ipa.setOplock(ipaDto.getOplock());
		ipa.setParticipationFormSigned(ipaDto.getParticipationFormSigned());
		if(log.isDebugEnabled()) {
			if(ipaDto.getAuthenticatingFacilityDTO()!=null)
				log.debug("@@@@@@@@@ipaDto.getAuthenticatingFacilityDTO().getId()"+ipaDto.getAuthenticatingFacilityDTO().getId());
			else
				log.debug("@@@@@@@@@ipaDto.getAuthenticatingFacilityDTO(): null");
		}
		
		ipa.setAuthenticatingFacility(FI_CONVERTER.convertDTOFacilityInfo(ipaDto.getAuthenticatingFacilityDTO()));
		ipa.setAuthenticatingFacilityId(ipaDto.getAuthenticatingFacilityDTO().getId());
		ipa.setRemovalReason(ipaDto.getRemovalReason());
		ipa.setSignedFormOnlineDateTime(ipaDto.getSignedFormOnlineDateTime());
		ipa.setStartUpgradeManualDateTime(ipaDto.getStartUpgradeManualDateTime());
		ipa.setStartUpgradeOnlineDateTime(ipaDto.getStartUpgradeOnlineDateTime());
		ipa.setStatus(ipaDto.getStatus());
		ipa.setVideoViewed(ipaDto.getVideoViewed());
		ipa.setPatientId(ipaDto.getPatientId());
		return ipa;
	}
	
//	public void addPatientProfile(InPersonAuthenticationDTOLight ipaDTO, InPersonAuthentication ipa) {
//		if (null != ipaDTO && null != ipa && null != ipaDTO.getPatient()) {
//			ipa.setPatient(patientConverter.convertDTOProfile(ipaDTO.getPatient()));
//		}
//	}
}